/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.KeySha;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantKeyCache {
    private final String logicalClusterId;
    private static Time time;
    private static final Logger log;
    private KeySha active;
    private final Map<KeySha, DataEncryptionKeyCacheEntry> cache;

    TenantKeyCache(Time time, String logicalClusterId, final int maxCacheSize) {
        this.logicalClusterId = logicalClusterId;
        TenantKeyCache.time = time;
        this.cache = new LinkedHashMap<KeySha, DataEncryptionKeyCacheEntry>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<KeySha, DataEncryptionKeyCacheEntry> eldest) {
                if (eldest.getKey().equals(TenantKeyCache.this.active)) {
                    ((DataEncryptionKeyCacheEntry)this.get(TenantKeyCache.this.active)).accessedNow();
                    return false;
                }
                return this.size() > maxCacheSize;
            }
        };
    }

    synchronized void maybeEvictEntriesTimeBased(long evictionTimeSeconds) {
        long now = time.milliseconds();
        Iterator<Map.Entry<KeySha, DataEncryptionKeyCacheEntry>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isEntryEligibleForEviction;
            Map.Entry<KeySha, DataEncryptionKeyCacheEntry> entry = iterator.next();
            boolean isEntryActive = entry.getKey().equals(this.active);
            boolean bl = isEntryEligibleForEviction = now - entry.getValue().lastAccessedTimeMs >= TimeUnit.SECONDS.toMillis(evictionTimeSeconds);
            if (isEntryActive || !isEntryEligibleForEviction) continue;
            log.info("[{}] Removing key {} from cache due to time-based expiry", (Object)this.logicalClusterId, (Object)entry.getKey());
            iterator.remove();
        }
    }

    synchronized void add(DataEncryptionKeyHolder keyHolder) {
        if (keyHolder == null) {
            throw new IllegalArgumentException("keyHolder cannot be null");
        }
        DataEncryptionKeyCacheEntry cacheEntry = this.cache.get(keyHolder.keySha);
        if (cacheEntry == null || cacheEntry.dataEncryptionKeyHolder.keyCreationTimeOpt.isEmpty()) {
            cacheEntry = new DataEncryptionKeyCacheEntry(keyHolder);
            this.cache.put(keyHolder.keySha, cacheEntry);
        } else {
            cacheEntry.accessedNow();
        }
    }

    synchronized KeySha activeKeySha() {
        return this.active;
    }

    synchronized void replaceActiveKey(DataEncryptionKeyHolder keyHolder) {
        this.active = keyHolder.keySha;
        this.add(keyHolder);
    }

    synchronized DataEncryptionKeyHolder get(KeySha keySha) {
        if (keySha == null) {
            throw new IllegalArgumentException("keySha cannot be null");
        }
        DataEncryptionKeyCacheEntry cacheEntry = this.cache.get(keySha);
        if (cacheEntry == null) {
            return null;
        }
        cacheEntry.accessedNow();
        return cacheEntry.dataEncryptionKeyHolder;
    }

    synchronized void clear() {
        this.active = null;
        this.cache.clear();
    }

    synchronized int size() {
        return this.cache.size();
    }

    synchronized boolean containsKey(KeySha keySha) {
        return this.cache.containsKey(keySha);
    }

    static {
        log = LoggerFactory.getLogger(TenantKeyCache.class);
    }

    private static class DataEncryptionKeyCacheEntry {
        final DataEncryptionKeyHolder dataEncryptionKeyHolder;
        long lastAccessedTimeMs;

        void accessedNow() {
            this.lastAccessedTimeMs = time.milliseconds();
        }

        DataEncryptionKeyCacheEntry(DataEncryptionKeyHolder dataEncryptionKeyHolder) {
            this.dataEncryptionKeyHolder = dataEncryptionKeyHolder;
            this.accessedNow();
        }
    }
}

