/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class HealthMetadata
implements ObjectStoreMetadata {
    private final int version = 0;
    private final Optional<String> clusterIdOpt;
    private final Optional<Integer> brokerIdOpt;

    public HealthMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        this.clusterIdOpt = clusterIdOpt;
        this.brokerIdOpt = brokerIdOpt;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadataVersion", Integer.toString(0));
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.HEALTH_CHECK) {
            throw new UnsupportedOperationException(String.format("HealthMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return String.format("%shealth/%s/health-checker.%s", keyPrefix, this.brokerIdOpt.orElse(-1), objectType.suffix());
    }
}

