/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import kafka.restore.RestoreUtil;
import kafka.server.KafkaConfig;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.tier.tools.ValidateFtpsSegmentsResponse;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class ValidateAndRestoreSegments {
    private static final Logger LOGGER = Logger.getLogger("ValidateAndRestoreSegments");
    public static final String DESCRIPTION = "Validate and restore inconsistent segment in FTPS from tiered storage";
    public static final String VALIDATE = "validate";
    public static final String VALIDATE_DOC = "Returns list of segment and metadata files which are not present in tiered storage";
    public static final String RESTORE = "restore";
    public static final String RESTORE_DOC = "Restores the given list of segment and metadata files from tiered storage";
    public static final String FTPS = "ftps";
    public static final String FTPS_DOC = "Path of the tier partition state file";
    public static final String FILES_TO_RESTORE = "files-to-restore";
    public static final String FILES_TO_RESTORE_DOC = "Path of the file containing files to restore";
    public static final String TOPIC_NAME = "topic-name";
    public static final String TOPIC_NAME_DOC = "Topic name";
    public static final String PARTITION = "partition";
    public static final String PARTITION_DOC = "Partition number";
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_LEVEL_DOC = "Logging level for the tool. Valid values: SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST, ALL";
    private static final String DEFAULT_KAFKA_PROPS_FILE = "/mnt/config/kafka.properties";
    private static final String DEFAULT_FILE_TO_RESTORE_JSON = "/tmp/restore.json";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static TierObjectStore.Backend backend = null;
    private static String objectStoreConfigFile;
    private static String ftps;
    private static String topicName;
    private static Integer partition;
    private static String filesToRestore;
    private static final Set<String> REQUIRED_OBJECT_TYPES;
    private static final List<String> OBJECT_STORE_REQUIRED_PROPERTIES;

    public static void run(Namespace args) throws ArgumentParserException, IOException {
        String option;
        switch (option = args.getString("option")) {
            case "validate": {
                ValidateAndRestoreSegments.loadArgumentsAndSetupLogger(args, option);
                Map<UUID, ObjectMetadata> objectMetadataMap = ValidateAndRestoreSegments.loadObjectMetadata(new File(ftps), new TopicPartition(topicName, partition), Optional.of(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
                ValidateAndRestoreSegments.getInconsistentSegments(ValidateAndRestoreSegments.objectStore(objectStoreConfigFile), objectMetadataMap);
                TierObjectStoreFactory.closeBackendInstance(backend);
                break;
            }
            case "restore": {
                ValidateAndRestoreSegments.loadArgumentsAndSetupLogger(args, option);
                Map<UUID, ObjectMetadata> objectMetadataMap = ValidateAndRestoreSegments.loadObjectMetadata(new File(ftps), new TopicPartition(topicName, partition), Optional.empty());
                ValidateAndRestoreSegments.restoreFiles(ValidateAndRestoreSegments.objectStore(objectStoreConfigFile), objectMetadataMap, filesToRestore);
                TierObjectStoreFactory.closeBackendInstance(backend);
                break;
            }
        }
    }

    private static void loadArgumentsAndSetupLogger(Namespace args, String option) {
        objectStoreConfigFile = args.getString("tier.config").trim();
        ftps = args.getString(FTPS).trim();
        topicName = args.getString(TOPIC_NAME).trim();
        partition = args.getInt(PARTITION);
        String loggingLevel = args.getString(LOGGING_LEVEL);
        if (option.equals(RESTORE)) {
            filesToRestore = args.getString(FILES_TO_RESTORE);
        }
        ValidateAndRestoreSegments.setupLogger(loggingLevel);
    }

    private static void restoreFiles(TierObjectStore tierObjectStore, Map<UUID, ObjectMetadata> objectMetadataMap, String filesToBeRestored) throws FileNotFoundException {
        try {
            int totalObjectStoreFilesRestored = 0;
            int totalSegmentsRestored = 0;
            int totalSegmentsFailed = 0;
            Gson gson = new Gson();
            JsonReader reader = new JsonReader(new FileReader(filesToBeRestored));
            ValidateFtpsSegmentsResponse.SegmentDetail[] segmentDetails = (ValidateFtpsSegmentsResponse.SegmentDetail[])gson.fromJson(reader, (Type)((Object)ValidateFtpsSegmentsResponse.SegmentDetail[].class));
            int totalSegmentsRequested = segmentDetails.length;
            for (ValidateFtpsSegmentsResponse.SegmentDetail segmentDetail : segmentDetails) {
                String dir = segmentDetail.getPrefix();
                UUID objectId = segmentDetail.getObjectId();
                Map<String, List<VersionInformation>> objectMapWithVersion = tierObjectStore.listObject(ValidateAndRestoreSegments.getSegmentDirectoryPath(dir), true);
                Map<String, String> versionMap = objectMapWithVersion.entrySet().stream().filter(e -> RestoreUtil.getLastLiveVersionId((String)e.getKey(), (List)e.getValue()) != null).collect(Collectors.toMap(Map.Entry::getKey, e -> RestoreUtil.getLastLiveVersionId((String)e.getKey(), (List)e.getValue())));
                boolean allFilesForSegmentRestoredSuccessfully = true;
                for (String file : segmentDetail.getFiles()) {
                    if (!versionMap.containsKey(file)) continue;
                    try {
                        tierObjectStore.restoreObjectByCopy(objectMetadataMap.get(objectId), file, new VersionInformation(versionMap.get(file)));
                        ++totalObjectStoreFilesRestored;
                        System.out.println(file + " Restored successfully");
                    }
                    catch (Exception e2) {
                        allFilesForSegmentRestoredSuccessfully = false;
                        LOGGER.info(file + "Failed to restore");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e3) {
                        throw new RuntimeException("Thread interrupted during sleep. Will exit", e3);
                    }
                }
                if (allFilesForSegmentRestoredSuccessfully) {
                    ++totalSegmentsRestored;
                } else {
                    ++totalSegmentsFailed;
                }
                LOGGER.info("Successfully restored " + totalSegmentsRestored + " segments (" + totalObjectStoreFilesRestored + " files) from total " + totalSegmentsRequested + " segments requested. Segments failed: " + totalSegmentsFailed);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.severe("File %s does not exist");
            throw fnfe;
        }
    }

    private static void getInconsistentSegments(TierObjectStore tierObjectStore, Map<UUID, ObjectMetadata> objectMetadataMap) throws IOException {
        LOGGER.info("Total segments found to check: " + objectMetadataMap.size());
        ValidateFtpsSegmentsResponse response = new ValidateFtpsSegmentsResponse();
        objectMetadataMap.forEach((segmentId, objectMetadata) -> {
            try {
                String segmentDirectoryPath = ValidateAndRestoreSegments.getSegmentDirectoryPath(objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath());
                ValidateFtpsSegmentsResponse.SegmentDetail canBeRestored = new ValidateFtpsSegmentsResponse.SegmentDetail(segmentDirectoryPath, (UUID)segmentId);
                ValidateFtpsSegmentsResponse.SegmentDetail cannotBeRestored = new ValidateFtpsSegmentsResponse.SegmentDetail(segmentDirectoryPath, (UUID)segmentId);
                Map<String, List<VersionInformation>> objectMapWithVersion = tierObjectStore.listObject(segmentDirectoryPath, true);
                LOGGER.fine("objectMapWithVersion:\n" + RestoreUtil.versionListMapToString(objectMapWithVersion));
                Map<String, List<VersionInformation>> objectMapWithoutVersion = tierObjectStore.listObject(segmentDirectoryPath, false);
                LOGGER.fine("objectMapWithoutVersion:\n" + objectMapWithoutVersion.toString());
                Set<String> requiredObjects = objectMetadata.segmentAndMetadataLayout().isPresent() ? objectMetadata.segmentAndMetadataLayout().get().fragmentDescriptionsList().stream().map(FragmentDescriptionWrapper::objectType).map(ObjectType::suffix).collect(Collectors.toSet()) : REQUIRED_OBJECT_TYPES;
                List<String> missingFiles = RestoreUtil.getMissingFiles(objectMapWithVersion, requiredObjects);
                if (!missingFiles.isEmpty()) {
                    LOGGER.fine("Found missing files: " + String.valueOf(missingFiles));
                    cannotBeRestored.getFiles().addAll(missingFiles);
                }
                objectMapWithVersion.forEach((filePath, versionInfo) -> {
                    LOGGER.fine("filePath: " + filePath);
                    if (!objectMapWithoutVersion.containsKey(filePath)) {
                        if (RestoreUtil.getLastLiveVersionId(filePath, versionInfo) != null) {
                            LOGGER.fine("filePath: " + filePath + " can be restored");
                            canBeRestored.getFiles().add((String)filePath);
                        } else {
                            LOGGER.fine("filePath: " + filePath + " cannot be restored");
                            cannotBeRestored.getFiles().add((String)filePath);
                        }
                    }
                });
                if (!canBeRestored.getFiles().isEmpty()) {
                    response.getCanBeRestored().add(canBeRestored);
                }
                if (!cannotBeRestored.getFiles().isEmpty()) {
                    response.getCannotBeRestored().add(cannotBeRestored);
                }
            }
            catch (Exception ex) {
                System.out.printf("Unable to get inconsistent files for segment: %s", segmentId);
            }
        });
        if (response.getCannotBeRestored().isEmpty() && response.getCanBeRestored().isEmpty()) {
            LOGGER.info("No inconsistent segments found.");
        } else {
            if (!response.getCannotBeRestored().isEmpty()) {
                LOGGER.info("Files missing from object store and cannot be restored\n");
                LOGGER.info(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(response.getCannotBeRestored()));
            }
            if (!response.getCanBeRestored().isEmpty()) {
                LOGGER.info("Files missing from object store and can be restored\n");
                try {
                    FileWriter writer = new FileWriter(DEFAULT_FILE_TO_RESTORE_JSON);
                    writer.write(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(response.getCanBeRestored()));
                    writer.close();
                    LOGGER.info("Files missing and can be restored can be found in /tmp/restore.json");
                }
                catch (IOException ioException) {
                    LOGGER.severe("Error writing to /tmp/restore.json");
                    LOGGER.info(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(response.getCanBeRestored()));
                }
            }
        }
    }

    private static String getSegmentDirectoryPath(String segmentPath) {
        return segmentPath.substring(0, segmentPath.lastIndexOf(47));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<UUID, ObjectMetadata> loadObjectMetadata(File stateFile, TopicPartition topicPartition, Optional<TierObjectMetadata.State> stateFilter) throws IOException {
        LOGGER.info("Reading ftps file: " + stateFile.getAbsolutePath());
        HashMap<UUID, ObjectMetadata> objectMetadataMap = new HashMap<UUID, ObjectMetadata>();
        try (CheckedFileIO stateFileChannel = CheckedFileIO.open(stateFile.toPath(), StandardOpenOption.READ);){
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(stateFileChannel);
            if (!headerOpt.isPresent()) {
                LOGGER.severe("Empty header at the tier state file");
                HashMap<UUID, ObjectMetadata> hashMap = objectMetadataMap;
                return hashMap;
            }
            LOGGER.info("====== Printing header ======\n" + String.valueOf(headerOpt.get()));
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, stateFileChannel);
            if (!iteratorOpt.isPresent()) {
                LOGGER.warning("Empty tier state file");
                HashMap<UUID, ObjectMetadata> hashMap = objectMetadataMap;
                return hashMap;
            }
            while (iteratorOpt.get().hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iteratorOpt.get().next();
                if (stateFilter.isPresent() && !metadata.state().equals((Object)stateFilter.get())) continue;
                objectMetadataMap.put(metadata.objectId(), new ObjectMetadata(metadata));
            }
            HashMap<UUID, ObjectMetadata> hashMap = objectMetadataMap;
            return hashMap;
        }
        catch (IOException e) {
            LOGGER.severe("IO Exception while reading tier state file");
            throw e;
        }
    }

    private static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        Time time = Time.SYSTEM;
        try {
            ArrayList<String> allProps = new ArrayList<String>(OBJECT_STORE_REQUIRED_PROPERTIES);
            props = Utils.loadProps(objectStoreConfigFile, allProps);
        }
        catch (IOException e) {
            LOGGER.severe("Can not load object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        props.put(KafkaConfig.TierGcsPrefixProp(), "");
        LOGGER.info("====== Loaded the following properties to access object store ======");
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOGGER.info(String.valueOf(k) + " -> " + String.valueOf(v))));
        TierObjectStore objectStore = ValidateAndRestoreSegments.getObjectStore(time, props);
        LOGGER.info("Successfully created an instance to object store. Backend: " + objectStore.getBackend().getName());
        return objectStore;
    }

    private static TierObjectStore getObjectStore(Time time, Properties props) {
        backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(time, backend, config);
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(ValidateAndRestoreSegments.class.getName()).defaultHelp(true).description(DESCRIPTION);
        Subparsers subParsers = parser.addSubparsers().dest("option").help("valid options: validate, restore");
        Subparser validateParser = subParsers.addParser(VALIDATE).help(VALIDATE_DOC);
        validateParser.addArgument(RecoveryUtils.makeArgument(FTPS)).dest(FTPS).type(String.class).required(true).help(FTPS_DOC);
        validateParser.addArgument(RecoveryUtils.makeArgument(TOPIC_NAME)).dest(TOPIC_NAME).type(String.class).required(true).help(TOPIC_NAME_DOC);
        validateParser.addArgument(RecoveryUtils.makeArgument(PARTITION)).dest(PARTITION).type(Integer.class).required(true).help(PARTITION_DOC);
        validateParser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(false).setDefault(DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        validateParser.addArgument(RecoveryUtils.makeArgument(LOGGING_LEVEL)).dest(LOGGING_LEVEL).type(String.class).required(false).setDefault("INFO").help(LOGGING_LEVEL_DOC);
        Subparser restoreParser = subParsers.addParser(RESTORE).help(RESTORE_DOC);
        restoreParser.addArgument(RecoveryUtils.makeArgument(FTPS)).dest(FTPS).type(String.class).required(true).help(FTPS_DOC);
        restoreParser.addArgument(RecoveryUtils.makeArgument(TOPIC_NAME)).dest(TOPIC_NAME).type(String.class).required(true).help(TOPIC_NAME_DOC);
        restoreParser.addArgument(RecoveryUtils.makeArgument(PARTITION)).dest(PARTITION).type(Integer.class).required(true).help(PARTITION_DOC);
        restoreParser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(false).setDefault(DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        restoreParser.addArgument(RecoveryUtils.makeArgument(FILES_TO_RESTORE)).dest(FILES_TO_RESTORE).type(String.class).required(true).help(FILES_TO_RESTORE_DOC);
        restoreParser.addArgument(RecoveryUtils.makeArgument(LOGGING_LEVEL)).dest(LOGGING_LEVEL).type(String.class).required(false).setDefault("INFO").help(LOGGING_LEVEL_DOC);
        return parser;
    }

    private static void setupLogger(String level) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter(){
            private static final String format = "[%1$-7s] %2$s %n";

            @Override
            public synchronized String format(LogRecord lr) {
                return String.format(format, lr.getLevel().getLocalizedName(), lr.getMessage());
            }
        });
        handler.setLevel(Level.parse(level));
        LOGGER.addHandler(handler);
        LOGGER.setUseParentHandlers(false);
        LOGGER.setLevel(Level.parse(level));
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = ValidateAndRestoreSegments.createArgParser();
            try {
                ValidateAndRestoreSegments.run(parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }

    static {
        REQUIRED_OBJECT_TYPES = new HashSet<String>(Arrays.asList(ObjectType.SEGMENT.suffix(), ObjectType.OFFSET_INDEX.suffix(), ObjectType.TIMESTAMP_INDEX.suffix(), ObjectType.PRODUCER_STATE.suffix(), ObjectType.EPOCH_STATE.suffix()));
        OBJECT_STORE_REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierBackendProp(), KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3AssumeRoleArnProp(), KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierGcsRegionProp(), KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsPrefixProp(), KafkaConfig.TierGcsCredFilePathProp(), KafkaConfig.TierGcsWriteChunkSizeProp(), KafkaConfig.TierAzureBlockBlobContainerProp(), KafkaConfig.TierAzureBlockBlobCredFilePathProp(), KafkaConfig.TierAzureBlockBlobEndpointProp(), KafkaConfig.TierAzureBlockBlobPrefixProp(), KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp());
    }
}

