/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.TestRaftServer;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.runtime.BoxesRunTime;

public final class TestRaftServer$
implements Logging {
    public static final TestRaftServer$ MODULE$ = new TestRaftServer$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TestRaftServer$ testRaftServer$ = this;
        synchronized (testRaftServer$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        TestRaftServer.TestRaftServerOptions opts = new TestRaftServer.TestRaftServerOptions(args);
        try {
            CommandLineUtils.maybePrintHelpOrVersion(opts, "Standalone raft server for performance testing");
            String configFile = opts.options.valueOf(opts.configOpt());
            if (configFile == null) {
                throw new InvalidConfigurationException("Missing configuration file. Should specify with '--config'");
            }
            String directoryIdAsString = opts.options.valueOf(opts.directoryId());
            if (directoryIdAsString == null) {
                throw new InvalidConfigurationException("Missing replica directory id. Should specify with --replica-directory-id");
            }
            Properties serverProps = Utils.loadProps(configFile);
            serverProps.put("process.roles", "controller");
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(serverProps, false);
            int throughput = BoxesRunTime.unboxToInt(opts.options.valueOf(opts.throughputOpt()));
            int recordSize = BoxesRunTime.unboxToInt(opts.options.valueOf(opts.recordSizeOpt()));
            TestRaftServer server = new TestRaftServer(config, Uuid.fromString(directoryIdAsString), throughput, recordSize);
            Exit.addShutdownHook("raft-shutdown-hook", () -> server.shutdown());
            server.startup();
            server.awaitShutdown();
            Exit.exit(0);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit(opts.parser, e.getMessage());
        }
        catch (Throwable e) {
            this.fatal((Function0<String> & Serializable)() -> "Exiting raft server due to fatal exception", (Function0<Throwable> & Serializable)() -> e);
            Exit.exit(1);
        }
    }

    private TestRaftServer$() {
    }
}

