/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;
import org.eclipse.jetty.websocket.core.internal.FrameFlusher;
import org.eclipse.jetty.websocket.core.internal.Generator;
import org.eclipse.jetty.websocket.core.internal.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends AbstractConnection
implements Connection.UpgradeTo,
Dumpable,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketConnection.class);
    private static final int MIN_BUFFER_SIZE = 28;
    private final AutoLock lock = new AutoLock();
    private final ByteBufferPool byteBufferPool;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketCoreSession coreSession;
    private final Flusher flusher;
    private final Random random;
    private DemandState demand = DemandState.NOT_DEMANDING;
    private boolean fillingAndParsing = true;
    private final LongAdder messagesIn = new LongAdder();
    private final LongAdder bytesIn = new LongAdder();
    private RetainableByteBuffer networkBuffer;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;
    private State state = State.IDLE;
    private Throwable closeCause;

    public WebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, WebSocketCoreSession coreSession) {
        this(endp, executor, scheduler, byteBufferPool, coreSession, null);
    }

    public WebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, WebSocketCoreSession coreSession, Random randomMask) {
        super(endp, executor);
        Objects.requireNonNull(endp, "EndPoint");
        Objects.requireNonNull(coreSession, "Session");
        Objects.requireNonNull(executor, "Executor");
        Objects.requireNonNull(byteBufferPool, "ByteBufferPool");
        this.byteBufferPool = byteBufferPool;
        this.coreSession = coreSession;
        this.generator = new Generator();
        this.parser = new Parser(byteBufferPool, coreSession);
        this.flusher = new Flusher(scheduler, coreSession.getOutputBufferSize(), this.generator, endp);
        this.setInputBufferSize(coreSession.getInputBufferSize());
        if (this.coreSession.getBehavior() == Behavior.CLIENT && randomMask == null) {
            randomMask = new SecureRandom();
        }
        this.random = randomMask;
    }

    public Executor getExecutor() {
        return super.getExecutor();
    }

    @Deprecated
    public InetSocketAddress getLocalAddress() {
        SocketAddress local = this.getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return (InetSocketAddress)local;
        }
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.getEndPoint().getLocalSocketAddress();
    }

    @Deprecated
    public InetSocketAddress getRemoteAddress() {
        SocketAddress remote = this.getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return (InetSocketAddress)remote;
        }
        return null;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.getEndPoint().getRemoteSocketAddress();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    @Deprecated(since="12.0.21", forRemoval=true)
    public void setWriteTimeout(long writeTimeout) {
        this.flusher.setFrameWriteTimeout(writeTimeout);
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    /*
     * Unable to fully structure code
     */
    public void onClose(Throwable cause) {
        if (WebSocketConnection.LOG.isDebugEnabled()) {
            WebSocketConnection.LOG.debug("onClose() of physical connection");
        }
        super.onClose(cause);
        close = false;
        ignored = this.lock.lock();
        try {
            this.closeCause = cause;
            switch (this.state.ordinal()) {
                case 1: {
                    this.state = State.CLOSED;
                    close = true;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 0: 
                case 2: 
                case 3: {
                    this.state = State.CLOSING;
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.state.name());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (close) {
            this.doOnClose(cause);
        }
    }

    private void doOnClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doOnClose() {}", (Object)String.valueOf(cause));
        }
        if (!this.coreSession.isClosed()) {
            this.coreSession.onEof();
        }
        this.flusher.onClose(cause);
        if (this.networkBuffer != null) {
            this.networkBuffer.clear();
            this.releaseNetworkBuffer();
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onIdleExpired()");
        }
        this.coreSession.processHandlerError(new WebSocketTimeoutException("Connection Idle Timeout", timeoutException), Callback.NOOP);
        return true;
    }

    protected boolean onReadTimeout(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onReadTimeout()");
        }
        this.coreSession.processHandlerError(new WebSocketTimeoutException("Timeout on Read", timeout), Callback.NOOP);
        return false;
    }

    protected void onFrame(final Frame.Parsed frame) {
        RetainableByteBuffer referenced;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFrame({})", (Object)frame);
        }
        RetainableByteBuffer retainableByteBuffer = referenced = frame.hasPayload() && !frame.isReleaseable() ? this.networkBuffer : null;
        if (referenced != null) {
            referenced.retain();
        }
        this.coreSession.onFrame(frame, new Callback(){
            final /* synthetic */ WebSocketConnection this$0;
            {
                this.this$0 = this$0;
            }

            public void succeeded() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("succeeded onFrame({})", (Object)frame);
                }
                frame.close();
                if (referenced != null) {
                    referenced.release();
                }
            }

            public void failed(Throwable cause) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("failed onFrame({}) {}", (Object)frame, (Object)cause.toString());
                }
                frame.close();
                if (referenced != null) {
                    referenced.release();
                }
                this.this$0.coreSession.processHandlerError(cause, NOOP);
            }
        });
    }

    private void acquireNetworkBuffer() {
        if (this.networkBuffer == null) {
            this.networkBuffer = this.newNetworkBuffer(this.getInputBufferSize());
        }
    }

    private void reacquireNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.getByteBuffer().hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        this.networkBuffer = this.newNetworkBuffer(this.getInputBufferSize());
    }

    private RetainableByteBuffer newNetworkBuffer(int capacity) {
        return this.byteBufferPool.acquire(capacity, this.isUseInputDirectByteBuffers());
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        this.networkBuffer = null;
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable()");
        }
        this.fillAndParse();
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("run()");
        }
        this.fillAndParse();
    }

    public void demand() {
        boolean fillAndParse = false;
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand {} fp={} {}", new Object[]{this.demand, this.fillingAndParsing, this});
            }
            if (this.demand != DemandState.CANCELLED) {
                if (this.demand == DemandState.DEMANDING) {
                    throw new ReadPendingException();
                }
                this.demand = DemandState.DEMANDING;
            }
            if (!this.fillingAndParsing) {
                this.fillingAndParsing = true;
                fillAndParse = true;
            }
        }
        if (fillAndParse) {
            this.getExecutor().execute(this);
        }
    }

    public boolean moreDemand() {
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("moreDemand? d={} fp={} {} {}", new Object[]{this.demand, this.fillingAndParsing, this.networkBuffer, this});
            }
            if (!this.fillingAndParsing) {
                throw new IllegalStateException();
            }
            switch (this.demand.ordinal()) {
                case 1: {
                    this.fillingAndParsing = false;
                    if (this.networkBuffer != null && !this.networkBuffer.hasRemaining()) {
                        this.releaseNetworkBuffer();
                    }
                    boolean bl = false;
                    return bl;
                }
                case 0: 
                case 2: {
                    boolean bl = true;
                    return bl;
                }
            }
            throw new IllegalStateException(this.demand.name());
        }
    }

    public boolean meetDemand() {
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("meetDemand d={} fp={} {} {}", new Object[]{this.demand, this.fillingAndParsing, this.networkBuffer, this});
            }
            if (this.demand == DemandState.NOT_DEMANDING) {
                throw new IllegalStateException();
            }
            if (!this.fillingAndParsing) {
                throw new IllegalStateException();
            }
            if (this.demand != DemandState.CANCELLED) {
                this.demand = DemandState.NOT_DEMANDING;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void cancelDemand() {
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelDemand d={} fp={} {} {}", new Object[]{this.demand, this.fillingAndParsing, this.networkBuffer, this});
            }
            this.demand = DemandState.CANCELLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillAndParse() {
        ignored = this.lock.lock();
        try {
            switch (this.state.ordinal()) {
                case 1: {
                    this.state = State.FILLING_AND_PARSING;
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.state = State.MORE_FILLING_AND_PARSING;
                    return;
                }
                case 4: 
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.state.name());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        fillingAndParsing = true;
        block79: while (true) {
            if (fillingAndParsing == false) return;
            this.acquireNetworkBuffer();
            registerFillInterested = false;
            while (true) {
                block114: {
                    try {
                        while (this.networkBuffer.hasRemaining() && (frame = this.parser.parse(this.networkBuffer.getByteBuffer())) != null) {
                            this.messagesIn.increment();
                            if (this.meetDemand()) {
                                this.onFrame(frame);
                            }
                            if (this.moreDemand()) continue;
                            fillingAndParsing = false;
                            close = false;
                            closeCause = null;
                            break block114;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable t) {
                        if (WebSocketConnection.LOG.isDebugEnabled()) {
                            WebSocketConnection.LOG.debug("Error during fillAndParse() {}", (Object)t.toString());
                        }
                        if (this.networkBuffer != null) {
                            BufferUtil.clear((ByteBuffer)this.networkBuffer.getByteBuffer());
                            this.releaseNetworkBuffer();
                        }
                        this.coreSession.processConnectionError(t, Callback.NOOP);
                        fillingAndParsing = false;
                        close = false;
                        closeCause = null;
                        ignored = this.lock.lock();
                        try {
                            switch (this.state.ordinal()) {
                                case 3: {
                                    if (registerFillInterested) {
                                        this.state = State.IDLE;
                                        ** break;
lbl54:
                                        // 1 sources

                                    } else {
                                        fillingAndParsing = true;
                                        this.state = State.FILLING_AND_PARSING;
                                        ** break;
                                    }
lbl58:
                                    // 1 sources

                                    break;
                                }
                                case 2: {
                                    this.state = State.IDLE;
                                    ** break;
lbl62:
                                    // 1 sources

                                    break;
                                }
                                case 4: {
                                    this.state = State.CLOSED;
                                    close = true;
                                    closeCause = this.closeCause;
                                    ** break;
lbl68:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new IllegalStateException(this.state.name());
                                }
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                        if (close) {
                            this.doOnClose(closeCause);
                            continue block79;
                        }
                        if (!registerFillInterested) continue block79;
                        this.fillInterested();
                        continue block79;
                    }
                    catch (Throwable var9_29) {
                        fillingAndParsing = false;
                        close = false;
                        closeCause = null;
                        ignored = this.lock.lock();
                        try {
                            switch (this.state.ordinal()) {
                                case 3: {
                                    if (registerFillInterested) {
                                        this.state = State.IDLE;
                                        ** break;
lbl93:
                                        // 1 sources

                                    } else {
                                        fillingAndParsing = true;
                                        this.state = State.FILLING_AND_PARSING;
                                        ** break;
                                    }
lbl97:
                                    // 1 sources

                                    break;
                                }
                                case 2: {
                                    this.state = State.IDLE;
                                    ** break;
lbl101:
                                    // 1 sources

                                    break;
                                }
                                case 4: {
                                    this.state = State.CLOSED;
                                    close = true;
                                    closeCause = this.closeCause;
                                    ** break;
lbl107:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new IllegalStateException(this.state.name());
                                }
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                        if (close) {
                            this.doOnClose(closeCause);
                            throw var9_29;
                        }
                        if (registerFillInterested == false) throw var9_29;
                        this.fillInterested();
                        throw var9_29;
                    }
                }
                ignored = this.lock.lock();
                try {
                    switch (this.state.ordinal()) {
                        case 3: {
                            if (registerFillInterested) {
                                this.state = State.IDLE;
                                ** break;
lbl129:
                                // 1 sources

                            } else {
                                fillingAndParsing = true;
                                this.state = State.FILLING_AND_PARSING;
                                ** break;
                            }
lbl133:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.state = State.IDLE;
                            ** break;
lbl137:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            this.state = State.CLOSED;
                            close = true;
                            closeCause = this.closeCause;
                            ** break;
lbl143:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.state.name());
                        }
                    }
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                if (close) {
                    this.doOnClose(closeCause);
                    return;
                }
                if (registerFillInterested == false) return;
                this.fillInterested();
                return;
lbl-1000:
                // 1 sources

                {
                    if (!WebSocketConnection.$assertionsDisabled && this.networkBuffer.hasRemaining()) {
                        throw new AssertionError();
                    }
                    if (this.getEndPoint().isOpen()) ** GOTO lbl-1000
                    this.releaseNetworkBuffer();
                    fillingAndParsing = false;
                    close = false;
                    closeCause = null;
                }
                ignored = this.lock.lock();
                try {
                    switch (this.state.ordinal()) {
                        case 3: {
                            if (registerFillInterested) {
                                this.state = State.IDLE;
                                ** break;
lbl171:
                                // 1 sources

                            } else {
                                fillingAndParsing = true;
                                this.state = State.FILLING_AND_PARSING;
                                ** break;
                            }
lbl175:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.state = State.IDLE;
                            ** break;
lbl179:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            this.state = State.CLOSED;
                            close = true;
                            closeCause = this.closeCause;
                            ** break;
lbl185:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.state.name());
                        }
                    }
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                if (close) {
                    this.doOnClose(closeCause);
                    return;
                }
                if (registerFillInterested == false) return;
                this.fillInterested();
                return;
lbl-1000:
                // 1 sources

                {
                    if (this.networkBuffer.isRetained()) {
                        this.reacquireNetworkBuffer();
                    }
                    this.networkBuffer.clear();
                    filled = this.getEndPoint().fill(this.networkBuffer.getByteBuffer());
                    if (WebSocketConnection.LOG.isDebugEnabled()) {
                        WebSocketConnection.LOG.debug("endpointFill() filled={}: {}", (Object)filled, (Object)this.networkBuffer);
                    }
                    if (filled >= 0) ** GOTO lbl-1000
                    this.releaseNetworkBuffer();
                    this.coreSession.onEof();
                    fillingAndParsing = false;
                    close = false;
                    closeCause = null;
                }
                ignored = this.lock.lock();
                try {
                    switch (this.state.ordinal()) {
                        case 3: {
                            if (registerFillInterested) {
                                this.state = State.IDLE;
                                ** break;
lbl218:
                                // 1 sources

                            } else {
                                fillingAndParsing = true;
                                this.state = State.FILLING_AND_PARSING;
                                ** break;
                            }
lbl222:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.state = State.IDLE;
                            ** break;
lbl226:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            this.state = State.CLOSED;
                            close = true;
                            closeCause = this.closeCause;
                            ** break;
lbl232:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.state.name());
                        }
                    }
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                if (close) {
                    this.doOnClose(closeCause);
                    return;
                }
                if (registerFillInterested == false) return;
                this.fillInterested();
                return;
lbl-1000:
                // 1 sources

                {
                    if (filled != 0) ** GOTO lbl-1000
                    this.releaseNetworkBuffer();
                    registerFillInterested = true;
                    fillingAndParsing = false;
                    close = false;
                    closeCause = null;
                }
                ignored = this.lock.lock();
                try {
                    switch (this.state.ordinal()) {
                        case 3: {
                            if (registerFillInterested) {
                                this.state = State.IDLE;
                                ** break;
lbl259:
                                // 1 sources

                            } else {
                                fillingAndParsing = true;
                                this.state = State.FILLING_AND_PARSING;
                                ** break;
                            }
lbl263:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.state = State.IDLE;
                            ** break;
lbl267:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            this.state = State.CLOSED;
                            close = true;
                            closeCause = this.closeCause;
                            ** break;
lbl273:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.state.name());
                        }
                    }
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                if (close) {
                    this.doOnClose(closeCause);
                    return;
                }
                if (registerFillInterested == false) return;
                this.fillInterested();
                return;
lbl-1000:
                // 1 sources

                {
                    this.bytesIn.add(filled);
                    continue;
                }
                break;
            }
            break;
        }
    }

    protected void setInitialBuffer(ByteBuffer initialBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set initial buffer - {}", (Object)BufferUtil.toDetailString((ByteBuffer)initialBuffer));
        }
        this.networkBuffer = this.newNetworkBuffer(initialBuffer.remaining());
        ByteBuffer buffer = this.networkBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        BufferUtil.put((ByteBuffer)initialBuffer, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
    }

    /*
     * Unable to fully structure code
     */
    public void onOpen() {
        if (WebSocketConnection.LOG.isDebugEnabled()) {
            WebSocketConnection.LOG.debug("onOpen() {}", (Object)this);
        }
        ignored = this.lock.lock();
        try {
            switch (this.state.ordinal()) {
                case 1: {
                    this.state = State.OPENING;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.state.name());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        super.onOpen();
        this.coreSession.onOpen();
        close = false;
        closeCause = null;
        ignored = this.lock.lock();
        try {
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = State.IDLE;
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.state = State.CLOSED;
                    close = true;
                    closeCause = this.closeCause;
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.state.name());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (close) {
            this.doOnClose(closeCause);
        } else if (this.moreDemand()) {
            this.fillAndParse();
        }
    }

    public void setInputBufferSize(int inputBufferSize) {
        if (inputBufferSize < 28) {
            throw new IllegalArgumentException("Cannot have buffer size less than 28");
        }
        super.setInputBufferSize(inputBufferSize);
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[0]);
    }

    public String toConnectionString() {
        return String.format("%s@%x[%s,p=%s,f=%s,g=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.coreSession.getBehavior(), this.parser, this.flusher, this.generator});
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onUpgradeTo({})", (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        this.setInitialBuffer(buffer);
    }

    public long getMessagesIn() {
        return this.messagesIn.longValue();
    }

    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    public long getMessagesOut() {
        return this.flusher.getMessagesOut();
    }

    public long getBytesOut() {
        return this.flusher.getBytesOut();
    }

    public void enqueueFrame(Frame frame, Callback callback, boolean batch) {
        if (this.coreSession.getBehavior() == Behavior.CLIENT) {
            byte[] mask = new byte[4];
            this.random.nextBytes(mask);
            frame.setMask(mask);
        }
        if (this.flusher.enqueue(frame, callback, batch)) {
            this.flusher.iterate();
        }
    }

    private static enum DemandState {
        DEMANDING,
        NOT_DEMANDING,
        CANCELLED;

    }

    private static enum State {
        OPENING,
        IDLE,
        FILLING_AND_PARSING,
        MORE_FILLING_AND_PARSING,
        CLOSING,
        CLOSED;

    }

    private class Flusher
    extends FrameFlusher {
        private Flusher(Scheduler scheduler, int bufferSize, Generator generator, EndPoint endpoint) {
            super(WebSocketConnection.this.byteBufferPool, scheduler, generator, endpoint, bufferSize, 8);
            this.setUseDirectByteBuffers(WebSocketConnection.this.isUseOutputDirectByteBuffers());
        }

        @Override
        public void onCompleteFailure(Throwable x) {
            WebSocketConnection.this.coreSession.processConnectionError(x, NOOP);
            super.onCompleteFailure(x);
        }
    }
}

