/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.audit.telemetry.exporter.TopicSpec;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;

public class DestinationTopicManagerConfig
extends AbstractConfig {
    public static final String ADMIN_CONFIG_PREFIX = "confluent.security.event.logger.destination.admin.";
    public static final String LEGACY_ADMIN_CONFIG_PREFIX = "confluent.security.event.logger.exporter.kafka.";
    public static final int REQUEST_TIMEOUT_MILLIS_DEFAULT = 120000;
    private static final Map<String, String> ACCEPTED_ALIASES;
    private static final Set<String> ADMIN_CONFIGS;
    private static final Set<String> ACCEPTED_CONFIGS;
    private static final ConfigDef CONFIG;
    private final ImmutableMap<String, Long> topicRetentionMillis;
    private final Map<String, Object> adminConfigProperties;

    private DestinationTopicManagerConfig(Map<String, ?> configs) {
        super(CONFIG, configs);
        AuditLogRouterJsonConfig routerJsonConfig;
        String routerConfig = this.getString("confluent.security.event.router.config");
        try {
            routerJsonConfig = routerConfig.isEmpty() ? AuditLogRouterJsonConfig.defaultConfig() : AuditLogRouterJsonConfig.load((String)routerConfig);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConfigException("confluent.security.event.router.config", (Object)routerConfig, "Invalid configuration: " + e.getMessage());
        }
        ImmutableMap.Builder topicRetentionMillis = ImmutableMap.builder();
        routerJsonConfig.destinations.topics.forEach((name, destinationTopic) -> topicRetentionMillis.put(name, (Object)destinationTopic.retentionMs));
        this.topicRetentionMillis = topicRetentionMillis.build();
        this.adminConfigProperties = this.originalsContainedInSetWithPrefix(ADMIN_CONFIGS, ADMIN_CONFIG_PREFIX);
        if (routerJsonConfig.bootstrapServers() != null && !routerJsonConfig.bootstrapServers().isEmpty()) {
            this.adminConfigProperties.put("bootstrap.servers", routerJsonConfig.bootstrapServers());
        }
    }

    private Map<String, Object> originalsContainedInSetWithPrefix(Set<String> set, String prefix) {
        int len = prefix.length();
        RecordingMap<Object> result = new RecordingMap<Object>(prefix);
        this.originals().forEach((k, v) -> {
            if (set.contains(k) && k.startsWith(prefix) && k.length() > len) {
                result.put(k.substring(len), v);
            }
        });
        return result;
    }

    public static DestinationTopicManagerConfig build(Map<String, ?> configs) {
        HashMap props = new HashMap();
        ACCEPTED_ALIASES.forEach((alternative, expected) -> {
            if (configs.containsKey(alternative)) {
                props.put(expected, configs.get(alternative));
            }
        });
        configs.forEach((k, v) -> {
            if (ACCEPTED_CONFIGS.contains(k) && !ACCEPTED_ALIASES.containsKey(k)) {
                props.put(k, v);
            }
        });
        return new DestinationTopicManagerConfig(props);
    }

    public static Set<String> acceptedConfigNames() {
        return ACCEPTED_CONFIGS;
    }

    public AdminClientConfig adminClientConfig() {
        try {
            return this.adminConfigProperties.isEmpty() ? null : new AdminClientConfig(this.adminConfigProperties);
        }
        catch (ConfigException e) {
            return null;
        }
    }

    public ImmutableMap<String, Long> topicRetentionMillis() {
        return this.topicRetentionMillis;
    }

    public TopicSpec buildTopicSpecFor(String topicName, long retentionMillis) throws ConfigException {
        return TopicSpec.builder().setName(topicName).setConfig((Map)ImmutableMap.of((Object)"message.timestamp.type", (Object)TimestampType.CREATE_TIME.name, (Object)"retention.ms", (Object)Long.toString(retentionMillis))).build();
    }

    public static int requestTimeoutMillis(DestinationTopicManagerConfig config) {
        if (config == null) {
            return 120000;
        }
        AdminClientConfig adminConfig = config.adminClientConfig();
        if (adminConfig == null) {
            return 120000;
        }
        return adminConfig.getInt("request.timeout.ms");
    }

    static {
        CONFIG = new ConfigDef();
        CONFIG.define("confluent.security.event.logger.enable", ConfigDef.Type.BOOLEAN, (Object)"true", ConfigDef.Importance.HIGH, "Whether the event logger is enabled");
        CONFIG.define("confluent.security.event.router.config", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "JSON configuration for routing events to topics");
        HashSet<CallSite> adminConfigs = new HashSet<CallSite>();
        HashMap<CallSite, CallSite> legacyAdminConfigs = new HashMap<CallSite, CallSite>();
        for (String name : AdminClientConfig.configNames()) {
            adminConfigs.add((CallSite)((Object)(ADMIN_CONFIG_PREFIX + name)));
            legacyAdminConfigs.put((CallSite)((Object)(LEGACY_ADMIN_CONFIG_PREFIX + name)), (CallSite)((Object)(ADMIN_CONFIG_PREFIX + name)));
        }
        ADMIN_CONFIGS = ImmutableSet.copyOf(adminConfigs);
        ACCEPTED_ALIASES = ImmutableMap.builder().putAll(legacyAdminConfigs).build();
        ACCEPTED_CONFIGS = ImmutableSet.builder().addAll((Iterable)CONFIG.names()).addAll(ADMIN_CONFIGS).addAll(ACCEPTED_ALIASES.keySet()).build();
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        private final String prefix;

        RecordingMap(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                DestinationTopicManagerConfig.this.ignore(this.prefix + String.valueOf(key));
            }
            return super.get(key);
        }
    }
}

