/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import io.confluent.common.security.auth.RestUserPrincipal;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class MdsBasicAuthenticator
extends BasicAuthenticator {
    public static final List<String> MDS_NO_AUTH_ENDPOINTS = Arrays.asList("/security/1.0/features", "/security/1.0/oidc/authenticate", "/security/1.0/oidc/authorization-code/callback", "/security/1.0/oidc/device/authenticate", "/security/1.0/oidc/device/check-auth", "/security/1.0/oidc/device/extend-auth");

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        boolean requestIsForNoAuthEndpoint = MDS_NO_AUTH_ENDPOINTS.stream().anyMatch(noAuthEndpoint -> request.getHttpURI().getCanonicalPath().equalsIgnoreCase((String)noAuthEndpoint));
        if (requestIsForNoAuthEndpoint) {
            UserIdentity userIdentity = this._identityService.newUserIdentity(new Subject(), (Principal)new RestUserPrincipal(""), new String[0]);
            return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), userIdentity);
        }
        return super.validateRequest(request, response, callback);
    }
}

