/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClusterAccessInfo {
    @JsonProperty(value="cluster")
    private final List<String> cluster;
    @JsonProperty(value="resources")
    private final Map<String, List<String>> resources;

    @JsonCreator
    public ClusterAccessInfo(@JsonProperty(value="cluster") @NotNull List<String> clusterParam, @JsonProperty(value="resources") @NotNull Map<String, List<String>> resourcesParam) {
        this.cluster = Objects.requireNonNull(clusterParam);
        this.resources = Objects.requireNonNull(resourcesParam);
    }

    public String toString() {
        return "ClusterAccessInfo{cluster=" + String.valueOf(this.cluster) + ", resources=" + String.valueOf(this.resources) + "}";
    }

    @JsonIgnore
    public List<String> getClusterAccess() {
        return this.cluster;
    }

    @JsonIgnore
    public Map<String, List<String>> getResourcesAccess() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAccessInfo that = (ClusterAccessInfo)o;
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.resources);
    }
}

