/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import io.confluent.rbacapi.entities.ClusterAccessInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterAccessInfoBuilder {
    private final Set<String> clusterAccess = new HashSet<String>(4);
    private final Map<String, Set<String>> resourceAccessMap;

    public ClusterAccessInfoBuilder(Set<String> resourceTypes) {
        this.resourceAccessMap = new HashMap<String, Set<String>>(resourceTypes.size() * 2);
        resourceTypes.forEach(resourceType -> this.resourceAccessMap.put((String)resourceType, new HashSet(4)));
    }

    public void addClusterAccess(Set<String> clusterAccessParam) {
        this.clusterAccess.addAll(clusterAccessParam);
    }

    public void addResourceAccess(String resourceType, Set<String> resourceAccessParam) {
        this.resourceAccessMap.computeIfAbsent(resourceType, key -> new HashSet()).addAll(resourceAccessParam);
    }

    public ClusterAccessInfo build() {
        for (Set<String> resourceAccess : this.resourceAccessMap.values()) {
            resourceAccess.addAll(this.clusterAccess);
        }
        ArrayList<String> clusterOutput = new ArrayList<String>(this.clusterAccess);
        Collections.sort(clusterOutput);
        HashMap<String, List<String>> resourceOutput = new HashMap<String, List<String>>();
        for (Map.Entry<String, Set<String>> mapEntry : this.resourceAccessMap.entrySet()) {
            String resourceType = mapEntry.getKey();
            Set<String> accessInput = mapEntry.getValue();
            ArrayList<String> access = new ArrayList<String>(accessInput);
            Collections.sort(access);
            resourceOutput.put(resourceType, access);
        }
        return new ClusterAccessInfo(clusterOutput, resourceOutput);
    }
}

