/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rbacapi.comparators.ScopeComparator;
import io.confluent.rbacapi.entities.HostInfo;
import io.confluent.rbacapi.entities.Protocol;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ClusterInfo
implements Comparable<ClusterInfo> {
    public static final int CLUSTER_NAME_MAX_SIZE = 80;
    @JsonProperty
    private final String clusterName;
    @JsonProperty
    private final Scope scope;
    @JsonProperty
    private final List<HostInfo> hosts;
    @JsonProperty
    private final Protocol protocol;

    @JsonCreator
    public ClusterInfo(@JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="hosts") List<HostInfo> hosts, @JsonProperty(value="protocol") Protocol protocol) {
        this.clusterName = clusterName;
        this.scope = scope;
        ArrayList<HostInfo> temp = new ArrayList<HostInfo>(hosts);
        Collections.sort(temp);
        this.hosts = temp;
        this.protocol = protocol;
    }

    private ClusterInfo(String clusterName, Scope scope) {
        this.clusterName = clusterName;
        this.scope = scope;
        this.hosts = Collections.emptyList();
        this.protocol = null;
    }

    public ClusterInfo redact() {
        return new ClusterInfo(this.clusterName, this.scope);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<HostInfo> getHosts() {
        return this.hosts;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public int compareTo(ClusterInfo that) {
        int nameCompare = this.clusterName.compareTo(that.clusterName);
        if (nameCompare != 0) {
            return nameCompare;
        }
        int scopeCompare = ScopeComparator.getInstance().compare(this.scope, that.scope);
        if (scopeCompare != 0) {
            return scopeCompare;
        }
        int protocolCompare = this.protocol.compareTo(that.protocol);
        if (protocolCompare != 0) {
            return protocolCompare;
        }
        if (this.hosts.size() != that.hosts.size()) {
            return this.hosts.size() - that.hosts.size();
        }
        for (int i = 0; i < this.hosts.size(); ++i) {
            int ithHostCompareTo = this.hosts.get(i).compareTo(that.hosts.get(i));
            if (ithHostCompareTo == 0) continue;
            return ithHostCompareTo;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.scope, that.scope) && Objects.equals((Object)this.protocol, (Object)that.protocol) && Objects.equals(this.hosts, that.hosts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterName, this.scope, this.hosts, this.protocol});
    }
}

