/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class HostInfo
implements Comparable<HostInfo> {
    @JsonProperty
    private final String host;
    @JsonProperty
    private final int port;

    @JsonCreator
    public HostInfo(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public int compareTo(HostInfo that) {
        int hostComp = this.host.compareTo(that.host);
        if (hostComp != 0) {
            return hostComp;
        }
        return Integer.compare(this.port, that.port);
    }

    public String toString() {
        return "HostInfo{host='" + this.host + "', port=" + this.port + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)o;
        return this.port == hostInfo.port && Objects.equals(this.host, hostInfo.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

