/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import java.util.EnumSet;

public enum Protocol {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    SASL_PLAINTEXT("SASL_PLAINTEXT"),
    SASL_SSL("SASL_SSL");

    private final String value;

    private Protocol(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static boolean isSASLProtocol(Protocol protocol) {
        return EnumSet.of(SASL_PLAINTEXT, SASL_SSL).contains((Object)protocol);
    }

    public static boolean isHttpProtocol(Protocol protocol) {
        return EnumSet.of(HTTP, HTTPS).contains((Object)protocol);
    }
}

