/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.rbacapi.utils.ClusterType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ResourceTypes {
    private static final Map<String, Set<String>> RESOURCE_TYPES_PER_CLUSTER_TYPE = ImmutableMap.of((Object)ClusterType.CONNECT_CLUSTER.value(), (Object)ImmutableSet.of((Object)"Connector"), (Object)ClusterType.CMF_CLUSTER.value(), (Object)ImmutableSet.of((Object)"Cluster", (Object)"FlinkEnvironment", (Object)"FlinkCatalog", (Object)"FlinkSecret"), (Object)ClusterType.FLINK_ENVIRONMENT.value(), (Object)ImmutableSet.of((Object)"FlinkApplication", (Object)"FlinkStatement", (Object)"FlinkComputePool"), (Object)ClusterType.KAFKA_CLUSTER.value(), (Object)ImmutableSet.of((Object)"Cluster", (Object)"Group", (Object)"Topic", (Object)"TransactionalId"), (Object)ClusterType.KSQL_CLUSTER.value(), (Object)ImmutableSet.of((Object)"KsqlCluster"), (Object)ClusterType.SCHEMA_REGISTRY_CLUSTER.value(), (Object)ImmutableSet.of((Object)"Subject", (Object)"Kek"));

    public static boolean containsCluster(ClusterType clusterType) {
        return RESOURCE_TYPES_PER_CLUSTER_TYPE.containsKey(clusterType.value());
    }

    public static Set<String> getResourceTypes(ClusterType clusterType) {
        return RESOURCE_TYPES_PER_CLUSTER_TYPE.getOrDefault(clusterType.value(), Collections.emptySet());
    }

    public static Map<String, Set<String>> getResourceTypesPerClusterType() {
        return RESOURCE_TYPES_PER_CLUSTER_TYPE;
    }
}

