/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rbacapi.comparators.ScopeComparator;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ScopeRoleBindingMapping
implements Comparable<ScopeRoleBindingMapping> {
    @JsonProperty(value="scope")
    private final MdsScope scope;
    @JsonProperty(value="rolebindings")
    private final Map<String, Map<String, Collection<ResourcePattern>>> principalRolesBindings;

    @JsonCreator
    ScopeRoleBindingMapping(@JsonProperty(value="scope") MdsScope scope, @JsonProperty(value="rolebindings") TreeMap<String, Map<String, Collection<ResourcePattern>>> principalRolesBindings) {
        this.scope = scope;
        this.principalRolesBindings = principalRolesBindings;
    }

    public ScopeRoleBindingMapping(MdsScope scope) {
        this.scope = scope;
        this.principalRolesBindings = new TreeMap<String, Map<String, Collection<ResourcePattern>>>();
    }

    public ScopeRoleBindingMapping(Scope scope) {
        this.scope = new MdsScope(null, scope);
        this.principalRolesBindings = new TreeMap<String, Map<String, Collection<ResourcePattern>>>();
    }

    public void addRoleBinding(RoleBinding roleBinding) {
        String principal = roleBinding.principal().toString();
        Map currentRolesBindings = this.principalRolesBindings.getOrDefault(principal, new TreeMap());
        currentRolesBindings.put(roleBinding.role(), (Collection)roleBinding.resources().stream().sorted().collect(Collectors.toList()));
        this.principalRolesBindings.put(principal, currentRolesBindings);
    }

    @JsonProperty
    public MdsScope scope() {
        return this.scope;
    }

    @JsonProperty
    public Map<String, Map<String, Collection<ResourcePattern>>> rolebindings() {
        return this.principalRolesBindings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeRoleBindingMapping that = (ScopeRoleBindingMapping)o;
        return this.scope.equals(that.scope) && this.principalRolesBindings.equals(that.principalRolesBindings);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.principalRolesBindings);
    }

    @Override
    public int compareTo(ScopeRoleBindingMapping other) {
        return ScopeComparator.getInstance().compare(this.scope.scope(), other.scope.scope());
    }

    public String toString() {
        return "ScopeRoleBindingMapping{scope=" + String.valueOf(this.scope) + ", principalRolesBindings=" + String.valueOf(this.principalRolesBindings) + "}";
    }
}

