/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.errorhandlers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;

public class NoJettyDefaultStackTraceErrorHandler
extends ErrorHandler {
    public NoJettyDefaultStackTraceErrorHandler() {
        this.setShowStacks(false);
        this.setShowCauses(false);
    }

    protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
        if (response.getHeaders() != null && response.getHeaders().contains(HttpHeader.WWW_AUTHENTICATE.asString())) {
            response.getHeaders().put(HttpHeader.WWW_AUTHENTICATE.asString(), "none");
        }
        return super.generateAcceptableResponse(request, response, callback, this.getResponseContentType(request), charsets, code, this.retrieveErrorMessage(code, message), cause);
    }

    protected String retrieveErrorMessage(int code, String message) {
        switch (code) {
            case 500: {
                return "Internal Server Error";
            }
        }
        return message;
    }

    private String getResponseContentType(Request baseRequest) {
        String acceptHeaderValue = baseRequest.getHeaders().get(HttpHeader.ACCEPT);
        if (acceptHeaderValue == null || acceptHeaderValue.equals("*/*")) {
            acceptHeaderValue = "application/json";
        }
        return acceptHeaderValue;
    }
}

