/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.errormappers;

import io.confluent.rbacapi.errors.ErrorBuilder;
import io.confluent.rbacapi.errors.ErrorDetail;
import io.confluent.rbacapi.errors.ErrorResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.stream.Collectors;

public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public static final String VALIDATION_ERROR_TYPE = "INVALID REQUEST DATA";

    public Response toResponse(ConstraintViolationException cve) {
        ErrorResponse errorResponse = cve.getConstraintViolations().size() == 0 ? ErrorBuilder.error(400, cve.getMessage()).type(VALIDATION_ERROR_TYPE).build() : (cve.getConstraintViolations().size() == 1 ? ErrorBuilder.error(400, ((ConstraintViolation)cve.getConstraintViolations().iterator().next()).getMessage()).type(VALIDATION_ERROR_TYPE).build() : ErrorBuilder.error(400, cve.getMessage()).type(VALIDATION_ERROR_TYPE).errors(cve.getConstraintViolations().stream().map(cv -> new ErrorDetail(cv.getConstraintDescriptor().getMessageTemplate(), cv.getMessage())).collect(Collectors.toList())).build());
        return Response.status((int)errorResponse.status).entity((Object)errorResponse).type("application/json").build();
    }
}

