/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.errormappers;

import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.KafkaExceptionMapper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.ApiException;

public class KafkaExecutionExceptionMapper
implements ExceptionMapper<ExecutionException> {
    private KafkaExceptionMapper kafkaExceptionMapper;
    private ExceptionMapper<Throwable> fallback;

    public KafkaExecutionExceptionMapper(RestConfig restConfig, ExceptionMapper<Throwable> fallback) {
        this.kafkaExceptionMapper = new KafkaExceptionMapper(restConfig);
        this.fallback = fallback;
    }

    public Response toResponse(ExecutionException exception) {
        if (exception.getCause() != null && exception.getCause() instanceof ApiException) {
            return this.kafkaExceptionMapper.toResponse((Throwable)exception);
        }
        return this.fallback.toResponse((Throwable)exception);
    }
}

