/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.errors;

import io.confluent.rbacapi.errors.ErrorDetail;
import io.confluent.rbacapi.errors.ErrorResponse;
import java.util.Arrays;
import java.util.List;

public final class ErrorBuilder {
    private final int status;
    private final String message;
    private String type = null;
    private Integer errorCode = null;
    private List<ErrorDetail> errors = null;

    private ErrorBuilder(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public static ErrorBuilder error(int status, String message) {
        return new ErrorBuilder(status, message);
    }

    public ErrorBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ErrorBuilder errorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public ErrorBuilder errors(ErrorDetail ... errors) {
        this.errors = Arrays.asList(errors);
        return this;
    }

    public ErrorBuilder errors(List<ErrorDetail> errors) {
        this.errors = errors;
        return this;
    }

    public ErrorResponse build() {
        return new ErrorResponse(this.status, this.errorCode, this.message, this.type, this.errors);
    }
}

