/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import io.confluent.security.roledefinitions.Role;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class MdsJacksonModule
extends SimpleModule {
    private static final String NAME = "MdsJacksonModule";

    public MdsJacksonModule() {
        super(NAME);
        this.addSerializer(KafkaPrincipal.class, new PrincipalSerializer());
        this.addDeserializer(KafkaPrincipal.class, new PrincipalDeserializer());
        this.addKeyDeserializer(KafkaPrincipal.class, new PrincipalKeyDeserializer());
        this.addSerializer(Role.class, new RoleSerializer());
        this.addSerializer(Scope.class, new ScopeSerializer());
        this.addDeserializer(AccessPolicy.class, new AccessPolicyDeserializer());
        this.addSerializer(Action.class, new ActionSerializer());
        this.addDeserializer(Action.class, new ActionDeserializer());
        this.addSerializer(ResourceType.class, new ResourceTypeSerializer());
        this.addDeserializer(ResourceType.class, new ResourceTypeDeserializer());
        this.addDeserializer(PatternType.class, new PatternTypeDeserializer());
    }

    public static class PrincipalSerializer
    extends JsonSerializer<KafkaPrincipal> {
        public void serialize(KafkaPrincipal principal, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(principal.toString());
        }
    }

    public static class PrincipalDeserializer
    extends JsonDeserializer<KafkaPrincipal> {
        public KafkaPrincipal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String principalString = node.asText();
            try {
                return SecurityUtils.parseKafkaPrincipal((String)principalString);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(jsonParser, e.getMessage());
            }
        }
    }

    public static class PrincipalKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String s, DeserializationContext deserializationContext) throws IOException {
            return SecurityUtils.parseKafkaPrincipal((String)s);
        }
    }

    public static class RoleSerializer
    extends JsonSerializer<Role> {
        public void serialize(Role role, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)role.displayName());
            gen.writeObjectField("namespace", (Object)role.namespace());
            gen.writeObjectField("internal", (Object)role.internal());
            Collection accessPolicies = role.flatAccessPolicies();
            gen.writeObjectField("policies", (Object)accessPolicies);
            gen.writeEndObject();
        }
    }

    public static class ScopeSerializer
    extends JsonSerializer<Scope> {
        public void serialize(Scope scope, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("clusters", (Object)scope.clusters());
            if (scope.path() != null && scope.path().size() != 0) {
                gen.writeObjectField("path", (Object)scope.path());
            }
            gen.writeEndObject();
        }
    }

    public static class AccessPolicyDeserializer
    extends JsonDeserializer<AccessPolicy> {
        public AccessPolicy deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String bindingScope = node.get("bindingScope").asText();
            Boolean bindWithResource = node.get("bindWithResource").asBoolean();
            JsonNode allowedOpsNode = node.get("allowedOperations");
            JsonParser subJsonParser = allowedOpsNode.traverse(oc);
            List allowedOperations = (List)subJsonParser.readValueAs((TypeReference)new TypeReference<List<AccessPolicy.ResourceOperations>>(){});
            return new AccessPolicy(bindingScope, bindWithResource, (Collection)allowedOperations);
        }
    }

    public static class ActionSerializer
    extends JsonSerializer<Action> {
        public void serialize(Action action, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("scope", (Object)action.scope());
            gen.writeObjectField("resourceName", (Object)action.resourceName());
            gen.writeObjectField("resourceType", (Object)action.resourceType().toString());
            gen.writeObjectField("operation", (Object)action.operation().toString());
            gen.writeEndObject();
        }
    }

    public static class ActionDeserializer
    extends JsonDeserializer<Action> {
        public Action deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String resourceType = node.get("resourceType").asText();
            JsonNode resourceNameNode = node.get("resourceName");
            String resourceName = resourceNameNode == null ? null : resourceNameNode.asText();
            String operation = node.get("operation").asText();
            JsonParser scopeParser = node.get("scope").traverse(oc);
            Scope scope = (Scope)scopeParser.readValueAs((TypeReference)new TypeReference<Scope>(){});
            return new Action(scope, new ResourceType(resourceType), resourceName, new Operation(operation));
        }
    }

    public static class ResourceTypeSerializer
    extends JsonSerializer<ResourceType> {
        public void serialize(ResourceType resourceType, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(resourceType.name());
        }
    }

    public static class ResourceTypeDeserializer
    extends JsonDeserializer<ResourceType> {
        public ResourceType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String name = node.asText();
            return new ResourceType(name);
        }
    }

    public static class PatternTypeDeserializer
    extends JsonDeserializer<PatternType> {
        private static final List<String> patternTypes = Arrays.stream(PatternType.values()).map(p -> p.name()).collect(Collectors.toList());

        public PatternType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String text = node.asText();
            if (patternTypes.contains(text)) {
                return PatternType.fromString((String)text);
            }
            throw new JsonParseException(jsonParser, "Invalid Pattern Type");
        }
    }
}

