/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.login;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.security.Credential;

public class HashedCredential
extends Credential {
    private final String credentialHash;
    private final String salt;
    private final BiFunction<String, Optional<String>, String> hashingFunction;
    private static final Pattern PATTERN = Pattern.compile("^(?:\\$(?<salt>[^$]+)\\$)?(?<hash>[^:]+)(?::(?<metadata>.*))?$");

    public HashedCredential(String credentialHash, BiFunction<String, Optional<String>, String> hashingFunction) {
        HashComponents hashComponents = HashedCredential.parseHash(credentialHash);
        this.credentialHash = hashComponents.getHash();
        this.salt = hashComponents.getSalt();
        this.hashingFunction = hashingFunction;
    }

    public boolean check(Object incomingCredentials) {
        if (incomingCredentials == null) {
            return false;
        }
        if (incomingCredentials instanceof String) {
            String password = (String)incomingCredentials;
            return this.check(password);
        }
        return false;
    }

    private boolean check(String incomingCredentials) {
        String hashedPassword = this.hashingFunction.apply(incomingCredentials, Optional.ofNullable(this.salt));
        return this.credentialHash.equals(hashedPassword);
    }

    private static HashComponents parseHash(String credentialHash) {
        Matcher matcher = PATTERN.matcher(credentialHash);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid hash format");
        }
        String salt = matcher.group("salt");
        String hash = matcher.group("hash");
        String metadata = matcher.group("metadata");
        return new HashComponents(salt, hash, metadata);
    }

    private static class HashComponents {
        private final String salt;
        private final String hash;
        private final String metadata;

        public HashComponents(String salt, String hash, String metadata) {
            this.salt = salt;
            this.hash = hash;
            this.metadata = metadata;
        }

        public String getSalt() {
            return this.salt;
        }

        public String getHash() {
            return this.hash;
        }

        public String getMetadata() {
            return this.metadata;
        }
    }
}

