/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.login;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.AuthorizationIdProvider;
import org.apache.kafka.common.security.plain.PlainAuthenticateCallback;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsLoginService
extends AbstractLoginService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger log = LoggerFactory.getLogger(MdsLoginService.class);
    private final String realmName;
    private final AuthenticateCallbackHandler callbackHandler;

    public MdsLoginService(String realmName, AuthenticateCallbackHandler callbackHandler) {
        this.realmName = realmName;
        this.callbackHandler = callbackHandler;
    }

    public String getName() {
        return this.realmName;
    }

    public UserIdentity login(String userName, Object credential, Request request, Function<Boolean, Session> getOrCreateSession) {
        log.trace("Login attempt for user {}", (Object)userName);
        PlainAuthenticateCallback plainCallback = new PlainAuthenticateCallback(((String)credential).toCharArray());
        NameCallback nameCallback = new NameCallback("Name: ", userName);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, plainCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            log.error("Login failed with checked exceptions for {}: {}", (Object)userName, (Object)e);
            return null;
        }
        catch (AuthenticationException e) {
            log.debug("Login failed with AuthenticationException for {}: {}", (Object)userName, (Object)e);
            return null;
        }
        catch (Throwable e) {
            log.error("Login failed with unknown exception for {}: {}", (Object)userName, (Object)e);
            return null;
        }
        if (!plainCallback.authenticated()) {
            log.debug("Login failed for {}", (Object)userName);
            return null;
        }
        if (this.callbackHandler instanceof AuthorizationIdProvider) {
            userName = nameCallback.getName();
        }
        log.debug("Login succeeded for {}", (Object)userName);
        return this.buildUserIdentity(userName, (String)credential);
    }

    private UserIdentity buildUserIdentity(String userName, String credential) {
        Password password = new Password(credential);
        Subject subject = new Subject();
        subject.getPublicCredentials().add(userName);
        subject.getPrivateCredentials().add(password);
        UserPrincipal principal = new UserPrincipal(userName, (Credential)password);
        return this._identityService.newUserIdentity(subject, (Principal)principal, EMPTY_STRING_ARRAY);
    }

    protected UserPrincipal loadUserInfo(String s) {
        throw new UnsupportedOperationException("loadUserInfo");
    }

    protected List<RolePrincipal> loadRoleInfo(UserPrincipal userPrincipal) {
        throw new UnsupportedOperationException("loadRoleInfo");
    }
}

