/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.entities.AuthorizeRequest;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class AuthorizeResource {
    private final Authorizer authorizer;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final ValidationUtil validationUtil;

    public AuthorizeResource(Authorizer authorizer, SecurityMetadataAuthorizer metadataAuthorizer, ValidationUtil validationUtil) {
        this.authorizer = authorizer;
        this.metadataAuthorizer = metadataAuthorizer;
        this.validationUtil = validationUtil;
    }

    public List<AuthorizeResult> authorize(SecurityContext context, AuthorizeRequest authorizeRequest) {
        return this.authorize(context, null, authorizeRequest);
    }

    public List<AuthorizeResult> authorize(SecurityContext context, String requestId, AuthorizeRequest authorizeRequest) {
        KafkaPrincipal targetPrincipal = this.getTargetPrincipal(authorizeRequest);
        this.metadataAuthorizer.authorizeAuthorizeRequest(context, targetPrincipal, authorizeRequest.actions);
        this.validationUtil.verifyScope(authorizeRequest);
        this.validationUtil.verifyOperation(authorizeRequest);
        this.validationUtil.verifyResourceType(authorizeRequest);
        List authorizeResults = this.authorizer.authorize(targetPrincipal, authorizeRequest.host, requestId, authorizeRequest.actions);
        return authorizeResults;
    }

    private KafkaPrincipal getTargetPrincipal(AuthorizeRequest authorizeRequest) {
        KafkaPrincipal userPrincipal = SecurityUtils.parseKafkaPrincipal((String)authorizeRequest.userPrincipal);
        if (authorizeRequest.groups != null && !authorizeRequest.groups.isEmpty()) {
            return new ConfluentPrincipal("User", userPrincipal.getName(), userPrincipal.getName(), Optional.empty(), false, authorizeRequest.groups);
        }
        return userPrincipal;
    }
}

