/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.security.auth.metadata.AuthStore;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

public class MetadataServiceResource {
    private final AuthStore authStore;
    private final String metadataClusterId;

    public MetadataServiceResource(AuthStore authStore, String metadataClusterId) {
        this.authStore = authStore;
        this.metadataClusterId = metadataClusterId;
    }

    public List<String> activeNodeWithSpecifiedProtocol(String protocol) {
        return this.lookupNodes(protocol);
    }

    public String getBackingKafkaClusterId() {
        return this.metadataClusterId;
    }

    private List<String> lookupNodes(String protocol) {
        return this.authStore.activeNodeUrls(protocol).stream().map(URL::toString).collect(Collectors.toList());
    }
}

