/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.Role;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ConfluentRoles;

public class RolesResource {
    private static final Logger log = LoggerFactory.getLogger(RolesResource.class);
    private final RbacRoles rbacRoles;
    private final Map<String, List<Role>> byNamespaces = new HashMap<String, List<Role>>();

    public RolesResource(RbacRoles rbacRoles) {
        this.rbacRoles = rbacRoles;
    }

    public List<Role> roles(String namespace) {
        return this.byNamespaces.computeIfAbsent(namespace, ns -> {
            String[] namespaces = ns.split(",");
            return Arrays.stream(namespaces).flatMap(n -> this.rbacRoles.roles(n).stream()).sorted(ConfluentRoles.comparator::compare).collect(Collectors.toList());
        });
    }

    public List<Role> roles() {
        return this.roles("public");
    }

    public Role role(String roleName, String namespace) {
        String[] namespaces = namespace.split(",");
        return Arrays.stream(namespace.split(",")).flatMap(ns -> this.rbacRoles.roles(ns).stream()).filter(r -> roleName.equals(r.displayName()) || roleName.equals(r.name())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Role role(String roleName) {
        return this.role(roleName, "public");
    }

    public List<String> roleNames(String namespace) {
        String[] namespaces = namespace.split(",");
        return Arrays.stream(namespaces).flatMap(ns -> this.rbacRoles.roles(ns).stream()).map(Role::displayName).sorted().distinct().collect(Collectors.toList());
    }

    public List<String> roleNames() {
        return this.roleNames("public");
    }
}

