/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import com.google.common.collect.ImmutableSet;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.resource.PatternType;

public class ResourceTypePermissions {
    private static final Set<String> IMPLICIT_DESCRIBE_ACCESS = ImmutableSet.of((Object)"DescribeAccess", (Object)"All");
    private static final Set<String> IMPLICIT_ALTER_ACCESS = ImmutableSet.of((Object)"AlterAccess", (Object)"All");
    private final ResourceType resourceType;
    private final Collection<String> clusterOperations;
    private final Map<String, Collection<String>> literalNamesOperations;
    private final InvertedRadixTree<Collection<String>> prefixNamesOperations;

    private ResourceTypePermissions(ResourceType resourceType, Collection<String> clusterOperations, Map<String, Collection<String>> literalNamesOperations, InvertedRadixTree<Collection<String>> prefixNamesOperations) {
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
        this.clusterOperations = Objects.requireNonNull(clusterOperations, "clusterOperations");
        this.literalNamesOperations = Objects.requireNonNull(literalNamesOperations, "literalNamesOperations");
        this.prefixNamesOperations = Objects.requireNonNull(prefixNamesOperations, "prefixNamesOperations");
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean canDescribeAccess() {
        return IMPLICIT_DESCRIBE_ACCESS.stream().anyMatch(op -> this.clusterOperations.contains(op));
    }

    public boolean canDescribeAccess(String resourceName, PatternType patternType) {
        return this.hasAnyOperation(IMPLICIT_DESCRIBE_ACCESS, resourceName, patternType);
    }

    public boolean canAlterAccess() {
        return IMPLICIT_ALTER_ACCESS.stream().anyMatch(op -> this.clusterOperations.contains(op));
    }

    public boolean canAlterAccess(String resourceName, PatternType patternType) {
        return this.hasAnyOperation(IMPLICIT_ALTER_ACCESS, resourceName, patternType);
    }

    public static Builder builder(ResourceType resourceType) {
        return new Builder(resourceType);
    }

    private boolean hasAnyOperation(Set<String> operations, String resourceName, PatternType patternType) {
        if (operations.stream().anyMatch(op -> this.clusterOperations.contains(op))) {
            return true;
        }
        HashSet<String> allowedOperations = new HashSet<String>();
        this.prefixNamesOperations.getValuesForKeysPrefixing((CharSequence)resourceName).forEach(allowedOperations::addAll);
        if (patternType == PatternType.LITERAL && this.literalNamesOperations.containsKey(resourceName)) {
            allowedOperations.addAll(this.literalNamesOperations.get(resourceName));
        }
        return operations.stream().anyMatch(op -> allowedOperations.contains(op));
    }

    public static class Builder {
        private final ResourceType resourceType;
        private final Collection<String> clusterOperations;
        private final Map<String, Collection<String>> literalNamesOperations;
        private final InvertedRadixTree<Collection<String>> prefixNamesOperations;

        public Builder(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.clusterOperations = new HashSet<String>();
            this.literalNamesOperations = new HashMap<String, Collection<String>>();
            this.prefixNamesOperations = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
        }

        public Builder addClusterOperations(Collection<String> operations) {
            this.clusterOperations.addAll(operations);
            return this;
        }

        public Builder putResourceOperations(String resourceName, PatternType patternType, Collection<String> operations) {
            switch (patternType) {
                case LITERAL: {
                    this.literalNamesOperations.put(resourceName, operations);
                    break;
                }
                case PREFIXED: {
                    this.prefixNamesOperations.put((CharSequence)resourceName, operations);
                    break;
                }
            }
            return this;
        }

        public ResourceTypePermissions build() {
            return new ResourceTypePermissions(this.resourceType, this.clusterOperations, this.literalNamesOperations, this.prefixNamesOperations);
        }
    }
}

