/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.utils;

import com.google.common.collect.ImmutableMap;
import io.confluent.security.authorizer.Scope;
import java.util.Map;
import java.util.function.Predicate;

public enum ClusterType {
    KAFKA_CLUSTER("kafka-cluster"),
    CMF_CLUSTER("cmf"),
    FLINK_ENVIRONMENT("flink-environment"),
    KSQL_CLUSTER("ksql-cluster"),
    CONNECT_CLUSTER("connect-cluster"),
    SCHEMA_REGISTRY_CLUSTER("schema-registry-cluster"),
    NOT_SPECIFIED("");

    private final String value;
    private static Map<String, ClusterType> CLUSTER_TYPES_MAP;

    private ClusterType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static ClusterType fromString(String clusterTypeStr) {
        ClusterType clusterType = CLUSTER_TYPES_MAP.get(clusterTypeStr.toLowerCase());
        if (clusterType == null) {
            throw new IllegalArgumentException(String.format("Cluster type '%s' not recognized", new Object[]{clusterType}));
        }
        return clusterType;
    }

    public static boolean valid(String type) {
        return CLUSTER_TYPES_MAP.containsKey(type);
    }

    public static ClusterType of(Scope scope) {
        Map clusters = scope.clusters();
        return CLUSTER_TYPES_MAP.values().stream().filter(type -> clusters.containsKey(type.value())).filter(type -> type == KAFKA_CLUSTER ? clusters.size() == 1 : true).findAny().orElse(NOT_SPECIFIED);
    }

    public static Predicate<Scope> filterScopeBy(ClusterType type) {
        return s -> {
            if (!s.clusters().containsKey(type.toString())) {
                return false;
            }
            if (type == KAFKA_CLUSTER) {
                return s.clusters().size() == 1;
            }
            if (type == CMF_CLUSTER) {
                return s.clusters().size() == 1;
            }
            if (type == FLINK_ENVIRONMENT) {
                return s.clusters().size() == 2 && s.clusters().containsKey(ClusterType.CMF_CLUSTER.value);
            }
            return true;
        };
    }

    static {
        CLUSTER_TYPES_MAP = ImmutableMap.of((Object)KAFKA_CLUSTER.toString(), (Object)((Object)KAFKA_CLUSTER), (Object)CMF_CLUSTER.toString(), (Object)((Object)CMF_CLUSTER), (Object)FLINK_ENVIRONMENT.toString(), (Object)((Object)FLINK_ENVIRONMENT), (Object)KSQL_CLUSTER.toString(), (Object)((Object)KSQL_CLUSTER), (Object)CONNECT_CLUSTER.toString(), (Object)((Object)CONNECT_CLUSTER), (Object)SCHEMA_REGISTRY_CLUSTER.toString(), (Object)((Object)SCHEMA_REGISTRY_CLUSTER));
    }
}

