/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.utils;

import com.google.common.collect.ImmutableSet;
import io.confluent.security.roledefinitions.ResourceType;
import io.confluent.security.roledefinitions.Role;
import java.util.Set;
import java.util.function.Predicate;

public final class RoleAccessUtils {
    private static final Set<String> DESCRIBE_ACCESS_OPS = ImmutableSet.of((Object)"All", (Object)"DescribeAccess");
    private static final Set<String> ALTER_ACCESS_OPS = ImmutableSet.of((Object)"All", (Object)"AlterAccess");
    private static final Set<String> DESCRIBE_OR_ALTER_ACCESS_OPS = ImmutableSet.of((Object)"All", (Object)"AlterAccess", (Object)"DescribeAccess");

    public static Predicate<Role> filterByDescribeAccess() {
        return role -> role.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations().stream()).anyMatch(ro -> ro.operations().stream().anyMatch(DESCRIBE_ACCESS_OPS::contains));
    }

    public static Predicate<Role> filterByDescribeOrAlterAccess() {
        return role -> role.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations().stream()).anyMatch(ro -> ro.operations().stream().anyMatch(DESCRIBE_OR_ALTER_ACCESS_OPS::contains));
    }

    public static boolean hasDescribeAccess(Role role, ResourceType resourceType) {
        return role.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations(resourceType).stream()).anyMatch(operation -> DESCRIBE_ACCESS_OPS.contains(operation.name()));
    }

    public static boolean hasAlterAccess(Role role, ResourceType resourceType) {
        return role.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations(resourceType).stream()).anyMatch(operation -> ALTER_ACCESS_OPS.contains(operation.name()));
    }
}

