/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.RbacRoles;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={OptionalResourceTypeValidator.class})
public @interface ValidOptionalResourceType {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "This message is not used.";

    public static class OptionalResourceTypeValidator
    implements ConstraintValidator<ValidOptionalResourceType, String> {
        private static final Set<String> VALID_RESOURCE_TYPES = new HashSet<String>();

        public static void loadResourceType(RbacRoles rbacRoles) {
            rbacRoles.roles().stream().flatMap(r -> r.flatAccessPolicies().stream()).map(AccessPolicy::allowedOperations).flatMap(Collection::stream).map(AccessPolicy.ResourceOperations::resourceType).forEach(VALID_RESOURCE_TYPES::add);
        }

        public void initialize(ValidOptionalResourceType constraintAnnotation) {
        }

        public boolean isValid(String resourceType, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (resourceType == null) {
                return true;
            }
            if (!VALID_RESOURCE_TYPES.contains(resourceType)) {
                context.buildConstraintViolationWithTemplate("Invalid resource type : " + resourceType).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

