/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PrincipalValidator.class})
public @interface ValidPrincipal {
    public static final Set<String> validPrincipalTypes = Set.of("User", "Group");

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Principal. Found: ${validatedValue}";

    public static class PrincipalValidator
    implements ConstraintValidator<ValidPrincipal, String> {
        public void initialize(ValidPrincipal constraintAnnotation) {
        }

        public boolean isValid(String principal, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            boolean valid = true;
            try {
                KafkaPrincipal parsedPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
                if (!validPrincipalTypes.contains(parsedPrincipal.getPrincipalType())) {
                    valid = false;
                } else if (parsedPrincipal.getName().isEmpty()) {
                    valid = false;
                }
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
            if (!valid) {
                context.buildConstraintViolationWithTemplate("Invalid principal : " + principal).addConstraintViolation();
            }
            return valid;
        }
    }
}

