/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.Role;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={RoleValidator.class})
public @interface ValidRole {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Role. Found: ${validatedValue}";

    public static class RoleValidator
    implements ConstraintValidator<ValidRole, String> {
        private static final Set<String> VALID_ROLE_NAMES = new HashSet<String>();

        public static void loadRoles(RbacRoles rbacRoles) {
            rbacRoles.roles().stream().map(Role::name).forEach(VALID_ROLE_NAMES::add);
            rbacRoles.roles().stream().map(Role::displayName).forEach(VALID_ROLE_NAMES::add);
        }

        public void initialize(ValidRole constraintAnnotation) {
        }

        public boolean isValid(String roleName, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (!VALID_ROLE_NAMES.contains(roleName)) {
                context.buildConstraintViolationWithTemplate("Invalid role name : " + roleName).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

