/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={TransactionIdValidator.class})
public @interface ValidTransactionId {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Transaction ID.";

    public static class TransactionIdValidator
    implements ConstraintValidator<ValidTransactionId, String> {
        public void initialize(ValidTransactionId constraintAnnotation) {
        }

        public boolean isValid(String organizationId, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (organizationId == null || organizationId.isEmpty()) {
                context.buildConstraintViolationWithTemplate("Invalid transaction ID : must not be empty").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

