/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.entities.HostInfo;
import io.confluent.rbacapi.entities.Protocol;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ClusterInfoValidator.class})
public @interface V1ValidClusterInfo {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid ClusterInfo";

    public static class ClusterInfoValidator
    implements ConstraintValidator<V1ValidClusterInfo, ClusterInfo> {
        private static final V1ValidationUtil validationUtil = new V1ValidationUtil();

        public void initialize(V1ValidClusterInfo constraintAnnotation) {
        }

        public boolean isValid(ClusterInfo clusterInfo, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (clusterInfo == null) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Expected non-null Cluster Info").addConstraintViolation();
                return false;
            }
            try {
                validationUtil.verifyScope(clusterInfo.getScope());
            }
            catch (ConstraintViolationException cve) {
                String message = cve.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo => " + message).addConstraintViolation();
                return false;
            }
            if (Objects.isNull((Object)clusterInfo.getProtocol())) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Protocol can not be empty.").addConstraintViolation();
                return false;
            }
            if (ClusterType.of(clusterInfo.getScope()) == ClusterType.KAFKA_CLUSTER) {
                if (!Protocol.isSASLProtocol(clusterInfo.getProtocol())) {
                    context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Protocol for kafka-cluster must be either SASL_PLAINTEXT or SASL_SSL.").addConstraintViolation();
                    return false;
                }
            } else if (!Protocol.isHttpProtocol(clusterInfo.getProtocol())) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Protocol for non kafka clusters must be either HTTP or HTTPS.").addConstraintViolation();
                return false;
            }
            if (clusterInfo.getHosts().isEmpty()) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Cluster should have at least one host.").addConstraintViolation();
                return false;
            }
            HashSet<HostInfo> hostSet = new HashSet<HostInfo>();
            for (HostInfo host : clusterInfo.getHosts()) {
                try {
                    validationUtil.verifyHostInfo(host);
                }
                catch (ConstraintViolationException cve) {
                    String message = cve.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
                    context.buildConstraintViolationWithTemplate("Invalid ClusterInfo => " + message).addConstraintViolation();
                    return false;
                }
                if (hostSet.add(host)) continue;
                context.buildConstraintViolationWithTemplate(String.format("Invalid ClusterInfo: Duplicate host entry %s", host.toString())).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

