/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.validator.StringValidator;
import io.confluent.rbacapi.validator.UnicodeClusterNameValidator;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ClusterInfoValidator.class})
public @interface V1ValidClusterName {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid ClusterInfo";

    public static class ClusterInfoValidator
    implements ConstraintValidator<V1ValidClusterName, String> {
        public void initialize(V1ValidClusterName constraintAnnotation) {
        }

        public boolean isValid(String clusterName, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (StringUtils.isBlank((CharSequence)clusterName)) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Cluster name should not be empty.").addConstraintViolation();
                return false;
            }
            if (!StringValidator.isValidLength(clusterName, 80)) {
                context.buildConstraintViolationWithTemplate(String.format("Invalid ClusterInfo: Cluster name should not be longer than %d bytes.", 80)).addConstraintViolation();
                return false;
            }
            if (StringValidator.containsWhiteSpaceOrNull(clusterName)) {
                context.buildConstraintViolationWithTemplate(String.format("Invalid ClusterInfo: Cluster name should not contain whitespaces.", 80)).addConstraintViolation();
                return false;
            }
            if (!UnicodeClusterNameValidator.isValidData(clusterName)) {
                context.buildConstraintViolationWithTemplate("Invalid ClusterInfo: Cluster name should contain only Unicode Letters, Numbers, Marker or .,&_+|[]/- special characters.").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

