/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import io.confluent.rbacapi.entities.HostInfo;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={HostInfoValidator.class})
public @interface V1ValidHostInfo {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid HostInfo";

    public static class HostInfoValidator
    implements ConstraintValidator<V1ValidHostInfo, HostInfo> {
        public void initialize(V1ValidHostInfo constraintAnnotation) {
        }

        public boolean isValid(HostInfo hostInfo, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (hostInfo == null) {
                context.buildConstraintViolationWithTemplate("Invalid HostInfo : HostInfo should be included in the request body").addConstraintViolation();
                return false;
            }
            String host = hostInfo.getHost();
            if (!InetAddresses.isInetAddress((String)host) && !InternetDomainName.isValid((String)host)) {
                context.buildConstraintViolationWithTemplate(String.format("Invalid HostInfo: Invalid host %s", host)).addConstraintViolation();
                return false;
            }
            int port = hostInfo.getPort();
            if (port < 1 || port > 65535) {
                context.buildConstraintViolationWithTemplate(String.format("Invalid HostInfo: Invalid port %d", port)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

