/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import com.google.common.collect.ImmutableSet;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.security.authorizer.Scope;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={MdsScopeValidator.class})
public @interface V1ValidMdsScope {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid Scope";

    public static class MdsScopeValidator
    implements ConstraintValidator<V1ValidMdsScope, MdsScope> {
        private static final String KAFKA_CLUSTER = ClusterType.KAFKA_CLUSTER.value();
        private static final String CMF_CLUSTER = ClusterType.CMF_CLUSTER.value();
        private static final String FLINK_ENVIRONMENT = ClusterType.FLINK_ENVIRONMENT.value();
        private static final String CONNECT_CLUSTER = ClusterType.CONNECT_CLUSTER.value();
        private static final String KSQL_CLUSTER = ClusterType.KSQL_CLUSTER.value();
        private static final String SCHEMA_REGISTRY_CLUSTER = ClusterType.SCHEMA_REGISTRY_CLUSTER.value();
        private static final Set<String> validClusterKeys = ImmutableSet.of((Object)KAFKA_CLUSTER, (Object)CMF_CLUSTER, (Object)FLINK_ENVIRONMENT, (Object)CONNECT_CLUSTER, (Object)KSQL_CLUSTER, (Object)SCHEMA_REGISTRY_CLUSTER, (Object[])new String[0]);

        public void initialize(V1ValidMdsScope constraintAnnotation) {
        }

        public boolean isValid(MdsScope mdsScope, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (mdsScope == null) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : Empty Scope. Check format.").addConstraintViolation();
                return false;
            }
            if (mdsScope.scope() != null) {
                Scope scope = mdsScope.scope();
                if (scope.path() != null && !scope.path().isEmpty()) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : path should be empty").addConstraintViolation();
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)mdsScope.clusterName())) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : either 'clusters' map or 'clusterName' should be specified but not both. Check format.").addConstraintViolation();
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)mdsScope.clusterName()) && scope.clusters().isEmpty() && scope.path().isEmpty()) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : Scope is empty. Check format.").addConstraintViolation();
                    return false;
                }
                if (scope.clusters() == null || scope.clusters().size() == 0 || scope.clusters().size() > 2) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : clusters should only contain one or two cluster id keys").addConstraintViolation();
                    return false;
                }
                if (!scope.clusters().keySet().contains(KAFKA_CLUSTER) && !scope.clusters().keySet().contains(CMF_CLUSTER)) {
                    context.buildConstraintViolationWithTemplate(String.format("Invalid Scope : Either %s or %s should always be defined", KAFKA_CLUSTER, CMF_CLUSTER)).addConstraintViolation();
                    return false;
                }
                if (scope.clusters().keySet().stream().anyMatch(key -> !validClusterKeys.contains(key))) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : invalid cluster key found").addConstraintViolation();
                    return false;
                }
                if (scope.clusters().values().stream().anyMatch(StringUtils::isBlank)) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : cluster value cannot be blank").addConstraintViolation();
                    return false;
                }
            }
            return true;
        }
    }
}

