/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.testng.util.Strings;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={BaseUriValidator.class})
public @interface V1ValidOidcCaller {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid caller.";

    public static class BaseUriValidator
    implements ConstraintValidator<V1ValidOidcCaller, URI> {
        public void initialize(V1ValidOidcCaller constraintAnnotation) {
        }

        public boolean isValid(URI baseUri, ConstraintValidatorContext context) {
            URL url;
            context.disableDefaultConstraintViolation();
            if (Objects.isNull(baseUri)) {
                context.buildConstraintViolationWithTemplate("Invalid caller: caller should not be empty.").addConstraintViolation();
                return false;
            }
            if (baseUri.isOpaque()) {
                context.buildConstraintViolationWithTemplate("Invalid caller: Opaque uris are not supported.").addConstraintViolation();
                return false;
            }
            try {
                url = new URL(baseUri.toString());
            }
            catch (Exception exception) {
                context.buildConstraintViolationWithTemplate("Invalid caller: " + exception.getMessage()).addConstraintViolation();
                return false;
            }
            if (Strings.isNotNullAndNotEmpty((String)url.getQuery())) {
                context.buildConstraintViolationWithTemplate("Invalid caller: QueryParams are not supported.").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

