/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.apache.kafka.common.resource.PatternType;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PatternTypeValidator.class})
public @interface V1ValidPatternType {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid pattern type. Found: ${validatedValue}";

    public static class PatternTypeValidator
    implements ConstraintValidator<V1ValidPatternType, PatternType> {
        public void initialize(V1ValidPatternType constraintAnnotation) {
        }

        public boolean isValid(PatternType patternType, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (!PatternType.LITERAL.equals((Object)patternType) && !PatternType.PREFIXED.equals((Object)patternType)) {
                context.buildConstraintViolationWithTemplate("Invalid pattern type : " + String.valueOf(patternType)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

