/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.RbacRoles;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={RoleResourceTypeValidator.class})
public @interface V1ValidRoleResourceType {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Resource Type. Found: ${validatedValue}";

    public static class RoleResourceTypeValidator
    implements ConstraintValidator<V1ValidRoleResourceType, RoleResourceType> {
        private static final Map<String, Set<String>> VALID_ROLE_RESOURCE_TYPES = new HashMap<String, Set<String>>();

        public static void loadRoleResourceType(RbacRoles rbacRoles) {
            rbacRoles.roles().stream().forEach(r -> {
                Set resourceTypes = r.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations().stream()).map(AccessPolicy.ResourceOperations::resourceType).collect(Collectors.toSet());
                VALID_ROLE_RESOURCE_TYPES.put(r.name(), resourceTypes);
            });
        }

        public void initialize(V1ValidRoleResourceType constraintAnnotation) {
        }

        public boolean isValid(RoleResourceType roleResourceType, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            String role = roleResourceType.getRole();
            String resourceType = roleResourceType.getResourceType();
            if (!VALID_ROLE_RESOURCE_TYPES.containsKey(role) || !VALID_ROLE_RESOURCE_TYPES.get(role).contains(resourceType)) {
                context.buildConstraintViolationWithTemplate("Invalid role resource type binding with role : " + role + " and resource type : " + resourceType).addConstraintViolation();
                return false;
            }
            return true;
        }
    }

    public static class RoleResourceType {
        private final String role;
        private final String resourceType;

        public RoleResourceType(String role, String resourceType) {
            this.role = role;
            this.resourceType = resourceType;
        }

        public String getRole() {
            return this.role;
        }

        public String getResourceType() {
            return this.resourceType;
        }
    }
}

