/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ResourceTypes;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.ResourceType;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ScopeResourceTypeValidator.class})
public @interface V1ValidScopeResourceType {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Scope Resource Type binding. Found: ${validatedValue}";

    public static class ScopeResourceTypeValidator
    implements ConstraintValidator<V1ValidScopeResourceType, ScopeResourceType> {
        public void initialize(V1ValidScopeResourceType constraintAnnotation) {
        }

        public boolean isValid(ScopeResourceType scopeResourceType, ConstraintValidatorContext context) {
            Map<String, Set<String>> resourceTypesPerClusterTypeMap = ResourceTypes.getResourceTypesPerClusterType();
            context.disableDefaultConstraintViolation();
            MdsScope mdsScope = scopeResourceType.getScope();
            String resourceType = scopeResourceType.getResourceType().name();
            String clusterType = ScopeResourceTypeValidator.getClusterType(mdsScope.scope());
            if (resourceTypesPerClusterTypeMap.get(clusterType) == null || !resourceTypesPerClusterTypeMap.get(clusterType).contains(resourceType)) {
                context.buildConstraintViolationWithTemplate("Invalid scope resource type binding with cluster type : " + clusterType + " and resource type : " + resourceType).addConstraintViolation();
                return false;
            }
            return true;
        }

        private static String getClusterType(Scope scope) {
            for (ClusterType clusterType : ClusterType.values()) {
                if (!ClusterType.filterScopeBy(clusterType).test(scope)) continue;
                return clusterType.value();
            }
            return "";
        }
    }

    public static class ScopeResourceType {
        private final MdsScope scope;
        private final ResourceType resourceType;

        public ScopeResourceType(MdsScope scope, ResourceType resourceType) {
            this.scope = scope;
            this.resourceType = resourceType;
        }

        public MdsScope getScope() {
            return this.scope;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }
    }
}

