/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.entities.AuthorizeRequest;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.entities.HostInfo;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ResourcesRequest;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.rbacapi.validation.common.ValidOperation;
import io.confluent.rbacapi.validation.common.ValidOrganizationId;
import io.confluent.rbacapi.validation.common.ValidPrincipal;
import io.confluent.rbacapi.validation.common.ValidResourceType;
import io.confluent.rbacapi.validation.common.ValidRole;
import io.confluent.rbacapi.validation.common.ValidTransactionId;
import io.confluent.rbacapi.validation.v1.V1ValidClusterInfo;
import io.confluent.rbacapi.validation.v1.V1ValidClusterInfoList;
import io.confluent.rbacapi.validation.v1.V1ValidClusterName;
import io.confluent.rbacapi.validation.v1.V1ValidHostInfo;
import io.confluent.rbacapi.validation.v1.V1ValidMdsScope;
import io.confluent.rbacapi.validation.v1.V1ValidPatternType;
import io.confluent.rbacapi.validation.v1.V1ValidResourcePattern;
import io.confluent.rbacapi.validation.v1.V1ValidRoleResourceType;
import io.confluent.rbacapi.validation.v1.V1ValidScope;
import io.confluent.rbacapi.validation.v1.V1ValidScopeResourceType;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import io.confluent.security.roledefinitions.Role;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.resource.PatternType;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class V1ValidationUtil
implements ValidationUtil {
    private static final Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();

    @Override
    public void verifyScope(Scope scope) {
        Set set = validator.validate((Object)new ScopeHolder(scope), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException("Invalid Scope", set);
        }
    }

    @Override
    public void verifyScope(ResourcesRequest rr) {
        Set set = validator.validate((Object)new MdsScopeHolder(rr.mdsScope), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException("Invalid Scope", set);
        }
    }

    @Override
    public void verifyScope(AuthorizeRequest authorizeRequest) {
        Optional<Set> optional = authorizeRequest.actions.stream().map(action -> validator.validate((Object)new ScopeHolder(action.scope()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Scope", optional.get());
        }
    }

    @Override
    public void verifyMdsScope(MdsScope scope) {
        Set set = validator.validate((Object)new MdsScopeHolder(scope), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException("Invalid Mds Scope", set);
        }
    }

    @Override
    public void verifyRoleResourceType(String role, ResourcesRequest rr) {
        Optional<Set> optional = rr.resourcePatterns.stream().map(resourcePattern -> validator.validate((Object)new RoleResourceTypeHolder(role, resourcePattern.resourceType().name()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Role and Resource Type binding", optional.get());
        }
    }

    @Override
    public void verifyRoleResourceType(String role, ResourcePattern rp) {
        Set violations = validator.validate((Object)new RoleResourceTypeHolder(role, rp.resourceType().name()), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException("Invalid Role and Resource Type binding", violations);
        }
    }

    @Override
    public void verifyPatternType(ResourcesRequest rr) {
        Optional<Set> optional = rr.resourcePatterns.stream().map(resourcePattern -> validator.validate((Object)new PatternTypeHolder(resourcePattern.patternType()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Pattern Type", optional.get());
        }
    }

    @Override
    public void verifyPatternType(PatternType pt) {
        Set violations = validator.validate((Object)new PatternTypeHolder(pt), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException("Invalid Pattern Type", violations);
        }
    }

    @Override
    public void verifyResourcePattern(ResourcesRequest rr) {
        Optional<Set> optional = rr.resourcePatterns.stream().map(resourcePattern -> validator.validate((Object)new ResourcePatternHolder((ResourcePattern)resourcePattern), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Resource Pattern", optional.get());
        }
    }

    @Override
    public void verifyResourcePattern(ResourcePattern rp) {
        Set violations = validator.validate((Object)new ResourcePatternHolder(rp), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException("Invalid Resource Pattern", violations);
        }
    }

    @Override
    public void verifyScopeResourceType(ResourcesRequest rr) {
        Optional<Set> optional = rr.resourcePatterns.stream().map(resourcePattern -> validator.validate((Object)new ScopeResourceTypeHolder(rr.mdsScope, resourcePattern.resourceType()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Scope Resource Type binding", optional.get());
        }
    }

    @Override
    public void verifyScopeResourceType(Scope scope, ResourceType rt) {
        Set violations = validator.validate((Object)new ScopeResourceTypeHolder(MdsScope.of(scope), rt), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException("Invalid Scope Resource Type binding", violations);
        }
    }

    @Override
    public void verifyResourceType(ResourcesRequest rr) {
        Optional<Set> optional = rr.resourcePatterns.stream().map(resourcePattern -> validator.validate((Object)new ResourceTypeHolder(resourcePattern.resourceType()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Resource Type", optional.get());
        }
    }

    @Override
    public void verifyResourceType(ResourceType rt) {
        Set violations = validator.validate((Object)new ResourceTypeHolder(rt), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException("Invalid Resource Type", violations);
        }
    }

    @Override
    public void verifyResourceType(AuthorizeRequest authorizeRequest) {
        Optional<Set> optional = authorizeRequest.actions.stream().map(action -> validator.validate((Object)new ResourceTypeHolder(action.resourceType()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Resource Type", optional.get());
        }
    }

    @Override
    public void verifyOperation(AuthorizeRequest authorizeRequest) {
        Optional<Set> optional = authorizeRequest.actions.stream().map(action -> validator.validate((Object)new OperationHolder(action.operation()), new Class[0])).filter(set -> !set.isEmpty()).findAny();
        if (optional.isPresent()) {
            throw new ConstraintViolationException("Invalid Operation", optional.get());
        }
    }

    public void verifyHostInfo(HostInfo hostInfo) {
        Set set = validator.validate((Object)new HostInfoHolder(hostInfo), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException("Invalid HostInfo", set);
        }
    }

    public void verifyClusterInfo(ClusterInfo clusterInfo) {
        Set set;
        if (clusterInfo != null) {
            this.verifyClusterName(clusterInfo.getClusterName());
        }
        if (!(set = validator.validate((Object)new ClusterInfoHolder(clusterInfo), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(set);
        }
    }

    public void verifyClusterName(String name) {
        Set set = validator.validate((Object)new ClusterNameHolder(name), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException(set);
        }
    }

    public void verifyClusterInfoList(List<ClusterInfo> clusterInfoList) {
        Set set = validator.validate((Object)new ClusterInfoListHolder(clusterInfoList), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException("Invalid ClusterInfo List", set);
        }
    }

    public void verifyOrganizationId(String id) {
        Set set = validator.validate((Object)new OrganizationIdHolder(id), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException(set);
        }
    }

    public void verifyTransactionId(String id) {
        Set set = validator.validate((Object)new TransactionIdHolder(id), new Class[0]);
        if (!set.isEmpty()) {
            throw new ConstraintViolationException(set);
        }
    }

    @Override
    public void validateRoleBindingScope(Role roleDefinition, Scope bindingScope) {
        String mostSpecific = roleDefinition.mostSpecificBindingScope();
        if (!mostSpecific.equals(bindingScope.bindingScope())) {
            throw new InvalidRequestException("Role " + roleDefinition.displayName() + " must be bound at scope " + mostSpecific + ", but was bound at " + bindingScope.bindingScope());
        }
    }

    public static class ScopeHolder {
        @V1ValidScope
        private final Scope scope;

        public ScopeHolder(Scope scope) {
            this.scope = scope;
        }
    }

    public static class MdsScopeHolder {
        @V1ValidMdsScope
        private final MdsScope mdsScope;

        public MdsScopeHolder(MdsScope mdsScope) {
            this.mdsScope = mdsScope;
        }
    }

    public static class RoleResourceTypeHolder {
        @V1ValidRoleResourceType
        private final V1ValidRoleResourceType.RoleResourceType roleResourceType;

        public RoleResourceTypeHolder(String role, String resourceType) {
            this.roleResourceType = new V1ValidRoleResourceType.RoleResourceType(role, resourceType);
        }
    }

    public static class PatternTypeHolder {
        @V1ValidPatternType
        private final PatternType patternType;

        public PatternTypeHolder(PatternType patternType) {
            this.patternType = patternType;
        }
    }

    public static class ResourcePatternHolder {
        @V1ValidResourcePattern
        private final ResourcePattern resourcePattern;

        public ResourcePatternHolder(ResourcePattern resourcePattern) {
            this.resourcePattern = resourcePattern;
        }
    }

    public static class ScopeResourceTypeHolder {
        @V1ValidScopeResourceType
        private final V1ValidScopeResourceType.ScopeResourceType scopeResourceType;

        public ScopeResourceTypeHolder(MdsScope mdsScope, ResourceType resourceType) {
            this.scopeResourceType = new V1ValidScopeResourceType.ScopeResourceType(mdsScope, resourceType);
        }
    }

    public static class ResourceTypeHolder {
        @ValidResourceType
        private final String resourceType;

        public ResourceTypeHolder(ResourceType resourceType) {
            this.resourceType = resourceType.name();
        }
    }

    public static class HostInfoHolder {
        @V1ValidHostInfo
        private final HostInfo hostInfo;

        public HostInfoHolder(HostInfo hostInfo) {
            this.hostInfo = hostInfo;
        }
    }

    public static class ClusterInfoHolder {
        @V1ValidClusterInfo
        private final ClusterInfo clusterInfo;

        public ClusterInfoHolder(ClusterInfo clusterInfo) {
            this.clusterInfo = clusterInfo;
        }
    }

    public static class ClusterNameHolder {
        @V1ValidClusterName
        private final String name;

        public ClusterNameHolder(String name) {
            this.name = name;
        }
    }

    public static class ClusterInfoListHolder {
        @V1ValidClusterInfoList
        private final List<ClusterInfo> clusterInfoList;

        public ClusterInfoListHolder(List<ClusterInfo> clusterInfoList) {
            this.clusterInfoList = clusterInfoList;
        }
    }

    public static class OrganizationIdHolder {
        @ValidOrganizationId
        private final String id;

        public OrganizationIdHolder(String id) {
            this.id = id;
        }
    }

    public static class TransactionIdHolder {
        @ValidTransactionId
        private final String id;

        public TransactionIdHolder(String id) {
            this.id = id;
        }
    }

    public static class OperationHolder {
        @ValidOperation
        private final String operation;

        public OperationHolder(Operation operation) {
            this.operation = operation.name();
        }
    }

    public static class PrincipalHolder {
        @ValidPrincipal
        private final String principal;

        public PrincipalHolder(String principal) {
            this.principal = principal;
        }
    }

    public static class RoleHolder {
        @ValidRole
        private final String roleName;

        public RoleHolder(Role role) {
            this.roleName = role.name();
        }
    }
}

