/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValidator {
    static final String SPACE_REGEX = "\\s";
    static final Pattern spacePattern = Pattern.compile("\\s");
    static final int MIN_LENGTH = 1;

    public static boolean isValidDataPattern(String input, Pattern regex) {
        if (StringValidator.isNull(input)) {
            return false;
        }
        Matcher matcher = regex.matcher(input);
        return matcher.matches();
    }

    public static boolean containsWhiteSpaceOrNull(String input) {
        if (StringValidator.isNull(input)) {
            return true;
        }
        Matcher matcher = spacePattern.matcher(input);
        return matcher.find();
    }

    public static boolean isNull(String input) {
        return input == null;
    }

    public static boolean isValidLength(String input, int maxLength) {
        if (StringValidator.isNull(input)) {
            return false;
        }
        int length = input.trim().length();
        return length <= maxLength;
    }

    public static boolean isValidMinLength(String input) {
        if (StringValidator.isNull(input)) {
            return true;
        }
        int length = input.trim().length();
        return 1 <= length;
    }
}

