/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.errormappers;

import com.google.common.collect.ImmutableMap;
import io.confluent.rbacapi.errors.ErrorBuilder;
import io.confluent.rbacapi.errors.ErrorResponse;
import io.confluent.tokenapi.exceptions.AuthenticationTokenException;
import io.confluent.tokenapi.exceptions.InvalidTokenException;
import io.confluent.tokenapi.exceptions.MalformedTokenException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationTokenExceptionMapper
implements ExceptionMapper<AuthenticationTokenException> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationTokenExceptionMapper.class);
    private static final Map<Class<? extends AuthenticationTokenException>, Response.Status> HANDLED = ImmutableMap.builder().put(AuthenticationTokenException.class, (Object)Response.Status.FORBIDDEN).put(InvalidTokenException.class, (Object)Response.Status.FORBIDDEN).put(MalformedTokenException.class, (Object)Response.Status.BAD_REQUEST).build();
    private ExceptionMapper<Throwable> fallback;

    public AuthenticationTokenExceptionMapper(ExceptionMapper<Throwable> fallback) {
        this.fallback = fallback;
    }

    public Response toResponse(AuthenticationTokenException tokenException) {
        if (HANDLED.containsKey(((Object)((Object)tokenException)).getClass())) {
            Response.Status status = HANDLED.get(((Object)((Object)tokenException)).getClass());
            int statusCode = status.getStatusCode();
            String type = status.getFamily().name();
            ErrorResponse errorResponse = ErrorBuilder.error(statusCode, tokenException.getMessage()).type(type).build();
            return Response.status((int)errorResponse.status).entity((Object)errorResponse).type("application/json").build();
        }
        return this.fallback.toResponse((Throwable)((Object)tokenException));
    }
}

