/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.jwt;

import io.confluent.rbacapi.app.RbacApiAppConfig;
import io.confluent.rest.RestConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class JwtConfig
extends RestConfig {
    private static ConfigDef config = JwtConfig.baseConfigDef();
    public static final String MAX_LIFETIME_PROP = "token.max.lifetime.ms";
    private static final long MAX_LIFETIME_DEFAULT = 21600000L;
    private static final String MAX_LIFETIME_DOC = "Specifies a tokens maximum configured lifetime im milliseconds";
    public static final String TOKEN_ISSUER_PROP = "token.issuer";
    protected static final String TOKEN_ISSUER_DEFAULT = "Confluent";
    protected static final String TOKEN_ISSUER_DOC = "An identifier for the token issuer.";
    public static final String TOKEN_ROLES_PROP = "token.roles";
    protected static final String TOKEN_ROLES_DEFAULT = "clusters";
    protected static final String TOKEN_ROLES_DOC = "Roles associated with an Authentication Token.";

    public static ConfigDef baseConfigDef() {
        return RbacApiAppConfig.baseConfigDef().define(TOKEN_ISSUER_PROP, ConfigDef.Type.STRING, (Object)TOKEN_ISSUER_DEFAULT, ConfigDef.Importance.HIGH, TOKEN_ISSUER_DOC).define(TOKEN_ROLES_PROP, ConfigDef.Type.STRING, (Object)TOKEN_ROLES_DEFAULT, ConfigDef.Importance.LOW, TOKEN_ROLES_DOC).define(MAX_LIFETIME_PROP, ConfigDef.Type.LONG, (Object)21600000L, ConfigDef.Importance.HIGH, MAX_LIFETIME_DOC);
    }

    public JwtConfig() {
        super(config);
    }

    protected JwtConfig(ConfigDef definition) {
        super(definition);
    }

    protected JwtConfig(Map<?, ?> originals) {
        this(config, originals);
    }

    protected JwtConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
    }
}

