/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.resources.base;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.auth.RestUserPrincipal;
import io.confluent.common.security.auth.entity.ImpersonateTokenRequest;
import io.confluent.tokenapi.entities.AuthenticationResponse;
import io.confluent.tokenapi.entities.RefreshTokenRequest;
import io.confluent.tokenapi.entities.SanitizeTokenRequest;
import io.confluent.tokenapi.services.TokenService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenResource {
    private static final Logger log = LoggerFactory.getLogger(TokenResource.class);
    private final TokenService tokenService;

    public TokenResource(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    public Response issueToken(SecurityContext auth, MultivaluedMap<String, String> headers, List<String> aud) {
        Optional<List<String>> mexValue = this.getHeaderValue(headers, "X-C3-Token-Max-Life");
        Map<String, Object> customClaims = null;
        long currentTimeMillis = System.currentTimeMillis();
        if (mexValue.isPresent()) {
            log.debug("Received C3_TOKEN_MAX_LIFE value as {} for principal: {}, is_basic: {}", new Object[]{mexValue.get().get(0), auth.getUserPrincipal().getName(), !(auth.getUserPrincipal() instanceof JwtPrincipal)});
            customClaims = this.tokenService.customClaimsForTokenLifetime(mexValue.get(), currentTimeMillis);
        }
        String token = this.tokenService.issueToken(auth.getUserPrincipal(), customClaims, aud);
        long tokenLifeTime = this.tokenService.getTokenLifeTime(token, currentTimeMillis);
        AuthenticationResponse authResponse = this.tokenService.getAuthenticationResponse(token, tokenLifeTime);
        String cookieHeader = this.tokenService.getCookieHeader(token, tokenLifeTime);
        return Response.ok((Object)authResponse).header(HttpHeader.SET_COOKIE.toString(), (Object)cookieHeader).build();
    }

    public Response clearToken() {
        AuthenticationResponse authResponse = this.tokenService.getAuthenticationResponse("", 0L);
        String cookieHeader = this.tokenService.getCookieHeader("", 0L);
        return Response.ok((Object)authResponse).header(HttpHeader.SET_COOKIE.toString(), (Object)cookieHeader).build();
    }

    public Response refreshToken(SecurityContext auth, RefreshTokenRequest refreshRequest) {
        String token = this.tokenService.refreshToken(auth.getUserPrincipal(), refreshRequest);
        AuthenticationResponse authResponse = this.tokenService.getAuthenticationResponse(token);
        String cookieHeader = this.tokenService.getCookieHeader(token);
        return Response.ok((Object)authResponse).header(HttpHeader.SET_COOKIE.toString(), (Object)cookieHeader).build();
    }

    public Response sanitizeToken(SecurityContext auth, SanitizeTokenRequest sanitizeTokenRequest) {
        String token = this.tokenService.sanitizeToken(auth.getUserPrincipal(), sanitizeTokenRequest);
        AuthenticationResponse authResponse = this.tokenService.getAuthenticationResponse(token);
        String cookieHeader = this.tokenService.getCookieHeader(token);
        return Response.ok((Object)authResponse).header(HttpHeader.SET_COOKIE.toString(), (Object)cookieHeader).build();
    }

    public Response impersonateToken(SecurityContext auth, HttpServletRequest httpServletRequest, ImpersonateTokenRequest impersonateTokenRequest, List<String> aud) {
        String proxy;
        String callingPrincipalName = auth.getUserPrincipal().getName();
        String targetPrincipalName = impersonateTokenRequest.getTargetPrincipalName();
        String targetPrincipalType = impersonateTokenRequest.getTargetPrincipalType();
        log.debug("Processing impersonation token request from User: {} for target principal name: {} and target principal type: {}", new Object[]{callingPrincipalName, targetPrincipalName, targetPrincipalType});
        if (!this.tokenService.validateImpersonationRequest(callingPrincipalName, targetPrincipalName)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        X509Certificate[] certs = (X509Certificate[])httpServletRequest.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            proxy = auth.getUserPrincipal().getName();
            log.warn("Certificate(s) couldn't be found during impersonation flow, hence using the auth Principal: {}", (Object)proxy);
        } else {
            proxy = certs[0].getSubjectX500Principal().getName();
            log.debug("Certificate(s) found during impersonation flow, hence using the certificate Principal: {}", (Object)proxy);
        }
        Map<String, Object> customClaims = this.tokenService.customClaimsForImpersonationRequest(proxy);
        RestUserPrincipal targetPrincipal = new RestUserPrincipal(targetPrincipalName);
        String token = this.tokenService.issueToken((Principal)targetPrincipal, customClaims, aud);
        AuthenticationResponse authResponse = this.tokenService.getAuthenticationResponse(token);
        return Response.ok((Object)authResponse).build();
    }

    private Optional<List<String>> getHeaderValue(MultivaluedMap<String, String> headers, String key) {
        return Optional.ofNullable((List)headers.get((Object)key));
    }
}

