/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.logging;

import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.logging.LoggingInterceptor;
import org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
public class MDSLoggingFilter
extends LoggingInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public MDSLoggingFilter(Logger logger, Level level, LoggingFeature.Verbosity verbosity, int maxEntitySize) {
        super(new LoggingFeature.LoggingFeatureBuilder().withLogger(logger).level(level).verbosity(verbosity).separator(" -- ").maxEntitySize(Integer.valueOf(maxEntitySize)));
    }

    public void filter(ContainerRequestContext context) throws IOException {
        try {
            this.doRequestFilter(context);
        }
        catch (EOFException e) {
            this.logger.log(Level.WARNING, "Client connection closed - EOF Exception while reading request stream.", e);
            throw new BadRequestException("Client connection closed.");
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        MultivaluedMap<String, String> modifiedHeaders = this.copyHeaders((MultivaluedMap<String, String>)responseContext.getStringHeaders());
        modifiedHeaders.remove((Object)"Set-Cookie");
        this.printPrefixedHeaders(b, id, "< ", modifiedHeaders);
        String path = requestContext.getUriInfo().getRequestUri().getPath();
        if (responseContext.hasEntity() && MDSLoggingFilter.printEntity((LoggingFeature.Verbosity)this.verbosity, (MediaType)responseContext.getMediaType()) && (path == null || !path.endsWith("/authenticate"))) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream((LoggingInterceptor)this, b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }

    protected void doRequestFilter(ContainerRequestContext context) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        if (context.getSecurityContext().getUserPrincipal() != null) {
            this.prefixId(b, id).append("> ").append("User Principal: ").append(context.getSecurityContext().getUserPrincipal().getName()).append("\n");
        }
        MultivaluedMap<String, String> modifiedHeaders = this.copyHeaders((MultivaluedMap<String, String>)context.getHeaders());
        modifiedHeaders.remove((Object)"Authorization");
        if (context.getCookies().containsKey("auth_token")) {
            modifiedHeaders.remove((Object)"Cookie");
        }
        this.printPrefixedHeaders(b, id, "> ", modifiedHeaders);
        if (context.hasEntity() && MDSLoggingFilter.printEntity((LoggingFeature.Verbosity)this.verbosity, (MediaType)context.getMediaType())) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset((MediaType)context.getMediaType())));
        }
        this.log(b);
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(id).append(" ");
        return b;
    }

    private MultivaluedMap<String, String> copyHeaders(MultivaluedMap<String, String> originalHeaders) {
        MultivaluedHashMap modifiedHeaders = new MultivaluedHashMap();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            String key = (String)entry.getKey();
            if ("Authorization".equalsIgnoreCase(key)) {
                key = "Authorization";
            } else if ("Cookie".equalsIgnoreCase(key)) {
                key = "Cookie";
            }
            modifiedHeaders.put((Object)key, (Object)((List)entry.getValue()));
        }
        return modifiedHeaders;
    }
}

