/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.confluent.security.roledefinitions.Role;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ConfluentRoles {
    public static final String ROLE_ORG_ADMIN = "OrganizationAdmin";
    public static final String ROLE_ENV_ADMIN = "EnvironmentAdmin";
    public static final String ROLE_CCLUSTER_ADMIN = "CloudClusterAdmin";
    public static final String ROLE_KSQL_ADMIN = "KsqlAdmin";
    public static final String ROLE_METRICS_VIEWER = "MetricsViewer";
    public static final String ROLE_OPERATOR = "Operator";
    public static final String ROLE_RESOURCE_OWNER = "ResourceOwner";
    public static final String ROLE_DEVELOPER_READ = "DeveloperRead";
    public static final String ROLE_DEVELOPER_WRITE = "DeveloperWrite";
    public static final String ROLE_DEVELOPER_MANAGE = "DeveloperManage";
    public static final List<String> ORDERED_ROLES = Arrays.asList("OrganizationAdmin", "EnvironmentAdmin", "CloudClusterAdmin", "KsqlAdmin", "Operator", "MetricsViewer", "ResourceOwner", "DeveloperManage", "DeveloperRead", "DeveloperWrite");
    public static final RoleDisplayComparator comparator = new RoleDisplayComparator();

    public static class RoleDisplayComparator
    implements Comparator<Role> {
        @Override
        public int compare(Role o1, Role o2) {
            int i1 = ORDERED_ROLES.indexOf(o1.displayName());
            int i2 = ORDERED_ROLES.indexOf(o2.displayName());
            if (i1 < 0) {
                if (i2 < 0) {
                    return o1.displayName().compareTo(o2.displayName());
                }
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return i1 - i2;
        }
    }
}

