/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringJoiner;

public class MetricValues {
    private final float[] values;
    private float max;
    private float sumForAvg;

    public MetricValues(int numWindows) {
        this.values = new float[numWindows];
        this.sumForAvg = 0.0f;
        this.max = Float.MIN_VALUE;
    }

    public MetricValues(MetricValues other) {
        this.values = new float[other.values.length];
        System.arraycopy(other.values, 0, this.values, 0, other.values.length);
        this.max = other.max;
        this.sumForAvg = other.sumForAvg;
    }

    public void set(int index, double value) {
        if (this.max == this.values[index] && value < (double)this.max) {
            this.max = Float.MIN_VALUE;
        }
        this.sumForAvg += (float)value - this.values[index];
        this.values[index] = (float)value;
    }

    public double get(int index) {
        return this.values[index];
    }

    public void clear() {
        Arrays.fill(this.values, 0.0f);
        this.sumForAvg = 0.0f;
        this.max = Float.MIN_VALUE;
    }

    public int length() {
        return this.values.length;
    }

    public void add(double[] values) {
        if (values.length != this.values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be added to the MetricValue with length %d", values.length, this.values.length));
        }
        this.max = Float.MIN_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            float toAdd = (float)values[i];
            int n = i;
            this.values[n] = this.values[n] + toAdd;
            this.sumForAvg += toAdd;
            this.max = Math.max(this.max, this.values[i]);
        }
    }

    public void add(MetricValues metricValues) {
        if (metricValues.length() != this.values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be added to the MetricValue with length %d", metricValues.length(), this.values.length));
        }
        this.max = Float.MIN_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            float toAdd = (float)metricValues.get(i);
            int n = i;
            this.values[n] = this.values[n] + toAdd;
            this.sumForAvg += toAdd;
            this.max = Math.max(this.max, this.values[i]);
        }
    }

    public void subtract(MetricValues metricValues) {
        if (metricValues.length() != this.values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be subtracted from the MetricValue with length %d", metricValues.length(), this.values.length));
        }
        this.max = Float.MIN_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            float toDeduct = (float)metricValues.get(i);
            int n = i;
            this.values[n] = this.values[n] - toDeduct;
            this.sumForAvg -= toDeduct;
            this.max = Math.max(this.max, this.values[i]);
        }
    }

    public void multiply(double multiplyBy) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * (float)multiplyBy;
        }
        this.max *= (float)multiplyBy;
        this.sumForAvg *= (float)multiplyBy;
    }

    public float avg() {
        return this.sumForAvg / (float)this.values.length;
    }

    public float max() {
        if (this.max >= 0.0f) {
            return this.max;
        }
        return this.updateMax();
    }

    public float latest() {
        return this.values[0];
    }

    public double[] doubleArray() {
        double[] result = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(String.format("{avg:\"%.3f\", max:\"%.3f\", {", Float.valueOf(this.avg()), Float.valueOf(this.max())).getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < this.values.length - 1; ++i) {
            out.write((i + ":" + this.values[i] + ", ").getBytes(StandardCharsets.UTF_8));
        }
        out.write((this.values.length - 1 + ":" + this.values[this.values.length - 1] + "}}").getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (int i = 0; i < this.values.length; ++i) {
            joiner.add(i + ":" + this.values[i]);
        }
        return String.format("{avg:%f, max:%f, %s}", Float.valueOf(this.avg()), Float.valueOf(this.max()), joiner.toString());
    }

    private float updateMax() {
        this.max = this.values[0];
        for (int i = 1; i < this.values.length; ++i) {
            this.max = Math.max(this.max, this.values[i]);
        }
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricValues that = (MetricValues)o;
        if (Float.compare(this.max, that.max) != 0) {
            return false;
        }
        if (Float.compare(this.sumForAvg, that.sumForAvg) != 0) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + (this.max != 0.0f ? Float.floatToIntBits(this.max) : 0);
        long temp = Float.floatToIntBits(this.sumForAvg);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

