/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AcceptanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class AnalyzerUtils {
    public static final String BROKERS = "brokers";
    public static final String REPLICAS = "replicas";
    public static final String TOPICS = "topics";
    public static final String METADATA = "metadata";
    public static final String POTENTIAL_NW_OUT = "potentialNwOut";
    public static final String LEADER_REPLICAS = "leaderReplicas";
    public static final String TOPIC_REPLICAS = "topicReplicas";
    public static final String STATISTICS = "statistics";
    public static final double EPSILON = 1.0E-5;

    private AnalyzerUtils() {
    }

    public static Set<PartitionProposal> getDiff(Map<TopicPartition, List<ReplicaId>> initialReplicaDistribution, Map<TopicPartition, ReplicaId> initialLeaderDistribution, Map<TopicPartition, List<ReplicaId>> initialObserverDistribution, ClusterModel optimizedClusterModel) {
        return AnalyzerUtils.getDiff(initialReplicaDistribution, initialLeaderDistribution, initialObserverDistribution, optimizedClusterModel, false);
    }

    public static Set<PartitionProposal> getDiff(Map<TopicPartition, List<ReplicaId>> initialReplicaDistribution, Map<TopicPartition, ReplicaId> initialLeaderDistribution, Map<TopicPartition, List<ReplicaId>> initialObserverDistribution, ClusterModel optimizedClusterModel, boolean skipReplicationFactorChangeCheck) {
        Map<TopicPartition, List<ReplicaId>> finalReplicaDistribution = optimizedClusterModel.getReplicaDistribution();
        Map<TopicPartition, List<ReplicaId>> finalObserverDistribution = optimizedClusterModel.getObserverDistribution();
        if (!(initialReplicaDistribution.keySet().equals(finalReplicaDistribution.keySet()) && initialReplicaDistribution.keySet().equals(initialObserverDistribution.keySet()) && initialObserverDistribution.keySet().equals(finalObserverDistribution.keySet()))) {
            throw new IllegalArgumentException("Attempt to diff distributions with different partitions.");
        }
        if (!skipReplicationFactorChangeCheck) {
            for (Map.Entry<TopicPartition, List<ReplicaId>> entry : initialReplicaDistribution.entrySet()) {
                TopicPartition tp = entry.getKey();
                List<ReplicaId> initialReplicas = entry.getValue();
                if (finalReplicaDistribution.get(tp).size() == initialReplicas.size()) continue;
                throw new IllegalArgumentException("Attempt to diff distributions with modified replication factor.");
            }
        }
        HashSet<PartitionProposal> diff = new HashSet<PartitionProposal>();
        for (Map.Entry<TopicPartition, List<ReplicaId>> entry : initialReplicaDistribution.entrySet()) {
            Set finalReplicasWithoutLeader;
            TopicPartition tp = entry.getKey();
            List<ReplicaId> initialReplicas = entry.getValue();
            List<ReplicaId> finalReplicas = finalReplicaDistribution.get(tp);
            List<ReplicaId> initialObservers = initialObserverDistribution.get(tp);
            List<ReplicaId> finalObservers = finalObserverDistribution.get(tp);
            initialReplicas.removeAll(initialObservers);
            finalReplicas.removeAll(finalObservers);
            ReplicaId initialLeader = initialLeaderDistribution.get(tp);
            ReplicaId finalLeader = new ReplicaId(optimizedClusterModel.partition(tp).leader().broker().id());
            Set initialReplicasWithoutLeader = initialReplicas.stream().filter(r -> !r.equals(initialLeader)).collect(Collectors.toSet());
            if (initialReplicasWithoutLeader.equals(finalReplicasWithoutLeader = finalReplicas.stream().filter(r -> !r.equals(finalLeader)).collect(Collectors.toSet())) && initialLeader.equals(finalLeader) && initialObservers.equals(finalObservers)) continue;
            if (finalLeader != finalReplicas.get(0)) {
                int leaderPos = finalReplicas.indexOf(finalLeader);
                finalReplicas.set(leaderPos, finalReplicas.get(0));
                finalReplicas.set(0, finalLeader);
            }
            long partitionSize = (long)optimizedClusterModel.partition(tp).leader().load().expectedUtilizationFor(Resource.DISK);
            diff.add(new PartitionProposal(tp, partitionSize, initialLeaderDistribution.get(tp), initialReplicas, finalReplicas, initialObservers, finalObservers));
        }
        return diff;
    }

    public static AcceptanceResult isProposalAcceptableForOptimizedGoals(Set<Goal> optimizedGoals, BalancingAction proposal, ClusterModel clusterModel) {
        for (Goal optimizedGoal : optimizedGoals) {
            ActionAcceptance actionAcceptance = optimizedGoal.actionAcceptance(proposal, clusterModel);
            if (actionAcceptance == ActionAcceptance.ACCEPT) continue;
            return new AcceptanceResult(actionAcceptance, optimizedGoal.name());
        }
        return AcceptanceResult.accepted();
    }

    public static int compare(double d1, double d2, Resource resource) {
        double epsilon = resource.epsilon(d1, d2);
        return AnalyzerUtils.compare(d1, d2, epsilon);
    }

    public static int compare(double d1, double d2, double epsilon) {
        if (d2 - d1 > epsilon) {
            return -1;
        }
        if (d1 - d2 > epsilon) {
            return 1;
        }
        return 0;
    }

    public static boolean isSmaller(double d1, double d2) {
        return Double.compare(d1, d2) < 0;
    }

    public static boolean isLarger(double d1, double d2) {
        return Double.compare(d1, d2) > 0;
    }

    public static boolean isLargerOrEqualTo(double d1, double d2) {
        return Double.compare(d1, d2) >= 0;
    }

    public static boolean isEqual(double d1, double d2) {
        return Double.compare(d1, d2) == 0;
    }
}

