/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPartitionMovementTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TopicPartitionMovementTracker.class);
    private final Set<TopicPartitionMovement> materializedOscillatingTopicPartitionMovements;
    private final Map<TopicPartitionMovement, Integer> topicPartitionMovementToCountMap;
    private final LinkedList<ListNode> topicPartitionMovementsQueue;
    private final LinkedList<ListNode> oscillatingTopicPartitionMovementsQueue;
    private final int suspendAfter;
    private final Time time;
    private final long suspensionPeriodMs;
    private final long movementsTrackingWindowMs;
    private final int movementHistoryLimit;

    public TopicPartitionMovementTracker(Time time, long movementsTrackingWindowMs, long suspensionPeriodMs, int suspendAfter, int movementHistoryLimit) {
        this.time = time;
        this.suspendAfter = suspendAfter;
        this.movementsTrackingWindowMs = movementsTrackingWindowMs;
        this.suspensionPeriodMs = suspensionPeriodMs;
        this.topicPartitionMovementToCountMap = new HashMap<TopicPartitionMovement, Integer>();
        this.materializedOscillatingTopicPartitionMovements = new HashSet<TopicPartitionMovement>();
        this.topicPartitionMovementsQueue = new LinkedList();
        this.oscillatingTopicPartitionMovementsQueue = new LinkedList();
        this.movementHistoryLimit = movementHistoryLimit;
    }

    public synchronized Set<TopicPartitionMovement> oscillatingTopicPartitionMovements() {
        long timeNow = this.time.hiResClockMs();
        this.expireTopicPartitionMovementsQueue(timeNow);
        this.expireOscillatingTopicPartitionMovementsQueue(timeNow);
        return Collections.unmodifiableSet(this.materializedOscillatingTopicPartitionMovements);
    }

    public synchronized void trackMovement(TopicPartitionMovement topicPartitionMovement) {
        Integer occurrences;
        long timeNow = this.time.hiResClockMs();
        this.expireTopicPartitionMovementsQueue(timeNow);
        this.expireOscillatingTopicPartitionMovementsQueue(timeNow);
        if (this.materializedOscillatingTopicPartitionMovements.contains(topicPartitionMovement)) {
            LOG.warn("The topic partition movement {} is already in the oscillating state. Skipping the tracking.", (Object)topicPartitionMovement);
            return;
        }
        this.topicPartitionMovementsQueue.add(new ListNode(topicPartitionMovement, timeNow + this.movementsTrackingWindowMs));
        Integer n = occurrences = this.topicPartitionMovementToCountMap.getOrDefault(topicPartitionMovement, 0);
        occurrences = occurrences + 1;
        this.topicPartitionMovementToCountMap.put(topicPartitionMovement, occurrences);
        if (occurrences > this.suspendAfter) {
            this.oscillatingTopicPartitionMovementsQueue.add(new ListNode(topicPartitionMovement, timeNow + this.suspensionPeriodMs));
            this.materializedOscillatingTopicPartitionMovements.add(topicPartitionMovement);
        }
    }

    private void expireTopicPartitionMovementsQueue(long timeNow) {
        if (this.topicPartitionMovementsQueue.isEmpty()) {
            return;
        }
        while (!this.topicPartitionMovementsQueue.isEmpty()) {
            Integer occurrences;
            ListNode node = this.topicPartitionMovementsQueue.peek();
            if (node.expiresAtMs >= timeNow && this.topicPartitionMovementsQueue.size() <= this.movementHistoryLimit) break;
            this.topicPartitionMovementsQueue.poll();
            Integer n = occurrences = this.topicPartitionMovementToCountMap.get(node.topicPartitionMovement);
            occurrences = occurrences - 1;
            if (occurrences == 0) {
                this.topicPartitionMovementToCountMap.remove(node.topicPartitionMovement);
                continue;
            }
            this.topicPartitionMovementToCountMap.put(node.topicPartitionMovement, occurrences);
        }
    }

    private void expireOscillatingTopicPartitionMovementsQueue(long timeNow) {
        if (this.oscillatingTopicPartitionMovementsQueue.isEmpty()) {
            return;
        }
        while (!this.oscillatingTopicPartitionMovementsQueue.isEmpty()) {
            ListNode node = this.oscillatingTopicPartitionMovementsQueue.peek();
            if (node.expiresAtMs >= timeNow) break;
            this.oscillatingTopicPartitionMovementsQueue.poll();
            this.materializedOscillatingTopicPartitionMovements.remove(node.topicPartitionMovement);
        }
    }

    private static class ListNode {
        final TopicPartitionMovement topicPartitionMovement;
        final long expiresAtMs;

        ListNode(TopicPartitionMovement topicPartitionMovement, long expiresAtMs) {
            this.topicPartitionMovement = topicPartitionMovement;
            this.expiresAtMs = expiresAtMs;
        }
    }
}

