/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatableBalancingConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatableBalancingConstraint.class);
    private volatile BalancingConstraint balancingConstraint;
    private volatile boolean usesCpuLowUtilizationThresholdForBrokerAddition;
    private final Set<String> updatableConfigs;

    public UpdatableBalancingConstraint(KafkaCruiseControlConfig kafkaCruiseControlConfig) {
        this.balancingConstraint = new BalancingConstraint(kafkaCruiseControlConfig);
        this.updatableConfigs = this.updatableConfigs();
    }

    public BalancingConstraint balancingConstraint() {
        return this.balancingConstraint;
    }

    public boolean isUpdatableConfig(String configKey) {
        return this.updatableConfigs.contains(configKey);
    }

    public void update(KafkaCruiseControlConfig kafkaCruiseControlConfig) {
        BalancingConstraint balancingConstraint = new BalancingConstraint(kafkaCruiseControlConfig);
        if (this.usesCpuLowUtilizationThresholdForBrokerAddition) {
            balancingConstraint.setLowUtilizationThresholdFor(Resource.CPU, balancingConstraint.cpuLowUtilizationThresholdForBrokerAddition());
        }
        this.balancingConstraint = balancingConstraint;
    }

    public void setDefaultCpuLowUtilizationThreshold(String reason) {
        if (!this.usesCpuLowUtilizationThresholdForBrokerAddition) {
            LOG.warn("CPU low utilization threshold is already set to the default value.");
        }
        this.usesCpuLowUtilizationThresholdForBrokerAddition = false;
        double defaultCpuLowUtilValue = this.balancingConstraint.defaultCpuLowUtilizationThreshold();
        LOG.info("Changing the CPU low utilization threshold to use its default value of {}%, reason: {}", (Object)defaultCpuLowUtilValue, (Object)reason);
        this.balancingConstraint.setLowUtilizationThresholdFor(Resource.CPU, defaultCpuLowUtilValue);
    }

    public void setCpuLowUtilizationThresholdForBrokerAddition(String reason) {
        if (this.usesCpuLowUtilizationThresholdForBrokerAddition) {
            LOG.warn("CPU low utilization threshold is already set to the broker additions value.");
        }
        this.usesCpuLowUtilizationThresholdForBrokerAddition = true;
        double brokerAdditionsCpuLowUtilValue = this.balancingConstraint.cpuLowUtilizationThresholdForBrokerAddition();
        LOG.info("Changing the CPU low utilization threshold to use its broker additions value of {}%, reason: {}", (Object)brokerAdditionsCpuLowUtilValue, (Object)reason);
        this.balancingConstraint.setLowUtilizationThresholdFor(Resource.CPU, brokerAdditionsCpuLowUtilValue);
    }

    private Set<String> updatableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add("cpu.low.utilization.threshold");
        configs.add("cpu.goal.act.as.capacity.goal");
        return configs;
    }

    public String toString() {
        return "UpdatableBalancingConstraint{balancingConstraint=" + String.valueOf(this.balancingConstraint) + "}";
    }
}

